-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MExpBoard = {}

---@class MExpBoard.SyncTimeSupport
---@field SyncTimeSupport integer
local TSyncTimeSupport = {}
TSyncTimeSupport.__index = TSyncTimeSupport
TSyncTimeSupport.group = {}

local function TSyncTimeSupport_from_obj(obj)
    return setmetatable(obj, TSyncTimeSupport)
end

function TSyncTimeSupport.new(SyncTimeSupport)
    return TSyncTimeSupport_from_obj({SyncTimeSupport = SyncTimeSupport or 0})
end
---@param obj MExpBoard.SyncTimeSupport
function TSyncTimeSupport:init_from_obj(obj)
    self.SyncTimeSupport = obj.SyncTimeSupport or 0
end

function TSyncTimeSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSyncTimeSupport.group)
end

TSyncTimeSupport.from_obj = TSyncTimeSupport_from_obj

TSyncTimeSupport.proto_property = {'SyncTimeSupport'}

TSyncTimeSupport.default = {0}

TSyncTimeSupport.struct = {{name = 'SyncTimeSupport', is_array = false, struct = nil}}

function TSyncTimeSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SyncTimeSupport', self.SyncTimeSupport, 'uint8', false, errs, need_convert)

    TSyncTimeSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSyncTimeSupport.proto_property, errs, need_convert)
    return self
end

function TSyncTimeSupport:unpack(_)
    return self.SyncTimeSupport
end

MExpBoard.SyncTimeSupport = TSyncTimeSupport

---@class MExpBoard.CpldTestNum
---@field CpldTestNum integer
local TCpldTestNum = {}
TCpldTestNum.__index = TCpldTestNum
TCpldTestNum.group = {}

local function TCpldTestNum_from_obj(obj)
    return setmetatable(obj, TCpldTestNum)
end

function TCpldTestNum.new(CpldTestNum)
    return TCpldTestNum_from_obj({CpldTestNum = CpldTestNum or 1})
end
---@param obj MExpBoard.CpldTestNum
function TCpldTestNum:init_from_obj(obj)
    self.CpldTestNum = obj.CpldTestNum or 1
end

function TCpldTestNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldTestNum.group)
end

TCpldTestNum.from_obj = TCpldTestNum_from_obj

TCpldTestNum.proto_property = {'CpldTestNum'}

TCpldTestNum.default = {0}

TCpldTestNum.struct = {{name = 'CpldTestNum', is_array = false, struct = nil}}

function TCpldTestNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldTestNum', self.CpldTestNum, 'uint8', false, errs, need_convert)

    TCpldTestNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldTestNum.proto_property, errs, need_convert)
    return self
end

function TCpldTestNum:unpack(_)
    return self.CpldTestNum
end

MExpBoard.CpldTestNum = TCpldTestNum

---@class MExpBoard.Count
---@field Count integer
local TCount = {}
TCount.__index = TCount
TCount.group = {}

local function TCount_from_obj(obj)
    return setmetatable(obj, TCount)
end

function TCount.new(Count)
    return TCount_from_obj({Count = Count or 0})
end
---@param obj MExpBoard.Count
function TCount:init_from_obj(obj)
    self.Count = obj.Count or 0
end

function TCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCount.group)
end

TCount.from_obj = TCount_from_obj

TCount.proto_property = {'Count'}

TCount.default = {0}

TCount.struct = {{name = 'Count', is_array = false, struct = nil}}

function TCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCount.proto_property, errs, need_convert)
    return self
end

function TCount:unpack(_)
    return self.Count
end

MExpBoard.Count = TCount

---@class MExpBoard.CpldTestReg
---@field CpldTestReg integer
local TCpldTestReg = {}
TCpldTestReg.__index = TCpldTestReg
TCpldTestReg.group = {}

local function TCpldTestReg_from_obj(obj)
    return setmetatable(obj, TCpldTestReg)
end

function TCpldTestReg.new(CpldTestReg)
    return TCpldTestReg_from_obj({CpldTestReg = CpldTestReg})
end
---@param obj MExpBoard.CpldTestReg
function TCpldTestReg:init_from_obj(obj)
    self.CpldTestReg = obj.CpldTestReg
end

function TCpldTestReg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldTestReg.group)
end

TCpldTestReg.from_obj = TCpldTestReg_from_obj

TCpldTestReg.proto_property = {'CpldTestReg'}

TCpldTestReg.default = {0}

TCpldTestReg.struct = {{name = 'CpldTestReg', is_array = false, struct = nil}}

function TCpldTestReg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldTestReg', self.CpldTestReg, 'uint32', false, errs, need_convert)

    TCpldTestReg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldTestReg.proto_property, errs, need_convert)
    return self
end

function TCpldTestReg:unpack(_)
    return self.CpldTestReg
end

MExpBoard.CpldTestReg = TCpldTestReg

---@class MExpBoard.Container
---@field Container string
local TContainer = {}
TContainer.__index = TContainer
TContainer.group = {}

local function TContainer_from_obj(obj)
    return setmetatable(obj, TContainer)
end

function TContainer.new(Container)
    return TContainer_from_obj({Container = Container})
end
---@param obj MExpBoard.Container
function TContainer:init_from_obj(obj)
    self.Container = obj.Container
end

function TContainer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainer.group)
end

TContainer.from_obj = TContainer_from_obj

TContainer.proto_property = {'Container'}

TContainer.default = {''}

TContainer.struct = {{name = 'Container', is_array = false, struct = nil}}

function TContainer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Container', self.Container, 'string', false, errs, need_convert)

    TContainer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainer.proto_property, errs, need_convert)
    return self
end

function TContainer:unpack(_)
    return self.Container
end

MExpBoard.Container = TContainer

---@class MExpBoard.RefSMCChip
---@field RefSMCChip integer[]
local TRefSMCChip = {}
TRefSMCChip.__index = TRefSMCChip
TRefSMCChip.group = {}

local function TRefSMCChip_from_obj(obj)
    return setmetatable(obj, TRefSMCChip)
end

function TRefSMCChip.new(RefSMCChip)
    return TRefSMCChip_from_obj({RefSMCChip = RefSMCChip})
end
---@param obj MExpBoard.RefSMCChip
function TRefSMCChip:init_from_obj(obj)
    self.RefSMCChip = obj.RefSMCChip
end

function TRefSMCChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefSMCChip.group)
end

TRefSMCChip.from_obj = TRefSMCChip_from_obj

TRefSMCChip.proto_property = {'RefSMCChip'}

TRefSMCChip.default = {{}}

TRefSMCChip.struct = {{name = 'RefSMCChip', is_array = true, struct = nil}}

function TRefSMCChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefSMCChip', self.RefSMCChip, 'uint8', false, errs, need_convert)

    TRefSMCChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefSMCChip.proto_property, errs, need_convert)
    return self
end

function TRefSMCChip:unpack(_)
    return self.RefSMCChip
end

MExpBoard.RefSMCChip = TRefSMCChip

---@class MExpBoard.RefMCUChip
---@field RefMCUChip integer[]
local TRefMCUChip = {}
TRefMCUChip.__index = TRefMCUChip
TRefMCUChip.group = {}

local function TRefMCUChip_from_obj(obj)
    return setmetatable(obj, TRefMCUChip)
end

function TRefMCUChip.new(RefMCUChip)
    return TRefMCUChip_from_obj({RefMCUChip = RefMCUChip})
end
---@param obj MExpBoard.RefMCUChip
function TRefMCUChip:init_from_obj(obj)
    self.RefMCUChip = obj.RefMCUChip
end

function TRefMCUChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefMCUChip.group)
end

TRefMCUChip.from_obj = TRefMCUChip_from_obj

TRefMCUChip.proto_property = {'RefMCUChip'}

TRefMCUChip.default = {{}}

TRefMCUChip.struct = {{name = 'RefMCUChip', is_array = true, struct = nil}}

function TRefMCUChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefMCUChip', self.RefMCUChip, 'uint8', false, errs, need_convert)

    TRefMCUChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefMCUChip.proto_property, errs, need_convert)
    return self
end

function TRefMCUChip:unpack(_)
    return self.RefMCUChip
end

MExpBoard.RefMCUChip = TRefMCUChip

---@class MExpBoard.FPGAVersionID
---@field FPGAVersionID integer
local TFPGAVersionID = {}
TFPGAVersionID.__index = TFPGAVersionID
TFPGAVersionID.group = {}

local function TFPGAVersionID_from_obj(obj)
    return setmetatable(obj, TFPGAVersionID)
end

function TFPGAVersionID.new(FPGAVersionID)
    return TFPGAVersionID_from_obj({FPGAVersionID = FPGAVersionID})
end
---@param obj MExpBoard.FPGAVersionID
function TFPGAVersionID:init_from_obj(obj)
    self.FPGAVersionID = obj.FPGAVersionID
end

function TFPGAVersionID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFPGAVersionID.group)
end

TFPGAVersionID.from_obj = TFPGAVersionID_from_obj

TFPGAVersionID.proto_property = {'FPGAVersionID'}

TFPGAVersionID.default = {0}

TFPGAVersionID.struct = {{name = 'FPGAVersionID', is_array = false, struct = nil}}

function TFPGAVersionID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FPGAVersionID', self.FPGAVersionID, 'uint8', false, errs, need_convert)

    TFPGAVersionID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFPGAVersionID.proto_property, errs, need_convert)
    return self
end

function TFPGAVersionID:unpack(_)
    return self.FPGAVersionID
end

MExpBoard.FPGAVersionID = TFPGAVersionID

---@class MExpBoard.CPLD2VersionID
---@field CPLD2VersionID integer
local TCPLD2VersionID = {}
TCPLD2VersionID.__index = TCPLD2VersionID
TCPLD2VersionID.group = {}

local function TCPLD2VersionID_from_obj(obj)
    return setmetatable(obj, TCPLD2VersionID)
end

function TCPLD2VersionID.new(CPLD2VersionID)
    return TCPLD2VersionID_from_obj({CPLD2VersionID = CPLD2VersionID})
end
---@param obj MExpBoard.CPLD2VersionID
function TCPLD2VersionID:init_from_obj(obj)
    self.CPLD2VersionID = obj.CPLD2VersionID
end

function TCPLD2VersionID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCPLD2VersionID.group)
end

TCPLD2VersionID.from_obj = TCPLD2VersionID_from_obj

TCPLD2VersionID.proto_property = {'CPLD2VersionID'}

TCPLD2VersionID.default = {0}

TCPLD2VersionID.struct = {{name = 'CPLD2VersionID', is_array = false, struct = nil}}

function TCPLD2VersionID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CPLD2VersionID', self.CPLD2VersionID, 'uint8', false, errs, need_convert)

    TCPLD2VersionID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCPLD2VersionID.proto_property, errs, need_convert)
    return self
end

function TCPLD2VersionID:unpack(_)
    return self.CPLD2VersionID
end

MExpBoard.CPLD2VersionID = TCPLD2VersionID

---@class MExpBoard.LogicVersionID
---@field LogicVersionID integer
local TLogicVersionID = {}
TLogicVersionID.__index = TLogicVersionID
TLogicVersionID.group = {}

local function TLogicVersionID_from_obj(obj)
    return setmetatable(obj, TLogicVersionID)
end

function TLogicVersionID.new(LogicVersionID)
    return TLogicVersionID_from_obj({LogicVersionID = LogicVersionID})
end
---@param obj MExpBoard.LogicVersionID
function TLogicVersionID:init_from_obj(obj)
    self.LogicVersionID = obj.LogicVersionID
end

function TLogicVersionID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVersionID.group)
end

TLogicVersionID.from_obj = TLogicVersionID_from_obj

TLogicVersionID.proto_property = {'LogicVersionID'}

TLogicVersionID.default = {0}

TLogicVersionID.struct = {{name = 'LogicVersionID', is_array = false, struct = nil}}

function TLogicVersionID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicVersionID', self.LogicVersionID, 'uint8', false, errs, need_convert)

    TLogicVersionID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicVersionID.proto_property, errs, need_convert)
    return self
end

function TLogicVersionID:unpack(_)
    return self.LogicVersionID
end

MExpBoard.LogicVersionID = TLogicVersionID

---@class MExpBoard.PcbID
---@field PcbID integer
local TPcbID = {}
TPcbID.__index = TPcbID
TPcbID.group = {}

local function TPcbID_from_obj(obj)
    return setmetatable(obj, TPcbID)
end

function TPcbID.new(PcbID)
    return TPcbID_from_obj({PcbID = PcbID})
end
---@param obj MExpBoard.PcbID
function TPcbID:init_from_obj(obj)
    self.PcbID = obj.PcbID
end

function TPcbID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbID.group)
end

TPcbID.from_obj = TPcbID_from_obj

TPcbID.proto_property = {'PcbID'}

TPcbID.default = {0}

TPcbID.struct = {{name = 'PcbID', is_array = false, struct = nil}}

function TPcbID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbID', self.PcbID, 'uint8', false, errs, need_convert)

    TPcbID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbID.proto_property, errs, need_convert)
    return self
end

function TPcbID:unpack(_)
    return self.PcbID
end

MExpBoard.PcbID = TPcbID

return MExpBoard
