-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftJTAG = {}

---@class MDftJTAG.Channel
---@field Channel integer
local TChannel = {}
TChannel.__index = TChannel
TChannel.group = {}

local function TChannel_from_obj(obj)
    return setmetatable(obj, TChannel)
end

function TChannel.new(Channel)
    return TChannel_from_obj({Channel = Channel})
end
---@param obj MDftJTAG.Channel
function TChannel:init_from_obj(obj)
    self.Channel = obj.Channel
end

function TChannel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel.group)
end

TChannel.from_obj = TChannel_from_obj

TChannel.proto_property = {'Channel'}

TChannel.default = {0}

TChannel.struct = {{name = 'Channel', is_array = false, struct = nil}}

function TChannel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel', self.Channel, 'uint8', false, errs, need_convert)

    TChannel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel.proto_property, errs, need_convert)
    return self
end

function TChannel:unpack(_)
    return self.Channel
end

MDftJTAG.Channel = TChannel

---@class MDftJTAG.InputChip
---@field InputChip integer[]
local TInputChip = {}
TInputChip.__index = TInputChip
TInputChip.group = {}

local function TInputChip_from_obj(obj)
    return setmetatable(obj, TInputChip)
end

function TInputChip.new(InputChip)
    return TInputChip_from_obj({InputChip = InputChip})
end
---@param obj MDftJTAG.InputChip
function TInputChip:init_from_obj(obj)
    self.InputChip = obj.InputChip
end

function TInputChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputChip.group)
end

TInputChip.from_obj = TInputChip_from_obj

TInputChip.proto_property = {'InputChip'}

TInputChip.default = {{}}

TInputChip.struct = {{name = 'InputChip', is_array = true, struct = nil}}

function TInputChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'InputChip', self.InputChip, 'uint8', false, errs, need_convert)

    TInputChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputChip.proto_property, errs, need_convert)
    return self
end

function TInputChip:unpack(_)
    return self.InputChip
end

MDftJTAG.InputChip = TInputChip

---@class MDftJTAG.SwitchData
---@field SwitchData integer
local TSwitchData = {}
TSwitchData.__index = TSwitchData
TSwitchData.group = {}

local function TSwitchData_from_obj(obj)
    return setmetatable(obj, TSwitchData)
end

function TSwitchData.new(SwitchData)
    return TSwitchData_from_obj({SwitchData = SwitchData})
end
---@param obj MDftJTAG.SwitchData
function TSwitchData:init_from_obj(obj)
    self.SwitchData = obj.SwitchData
end

function TSwitchData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSwitchData.group)
end

TSwitchData.from_obj = TSwitchData_from_obj

TSwitchData.proto_property = {'SwitchData'}

TSwitchData.default = {0}

TSwitchData.struct = {{name = 'SwitchData', is_array = false, struct = nil}}

function TSwitchData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SwitchData', self.SwitchData, 'uint8', false, errs, need_convert)

    TSwitchData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSwitchData.proto_property, errs, need_convert)
    return self
end

function TSwitchData:unpack(_)
    return self.SwitchData
end

MDftJTAG.SwitchData = TSwitchData

---@class MDftJTAG.SwitchAccessor
---@field SwitchAccessor integer
local TSwitchAccessor = {}
TSwitchAccessor.__index = TSwitchAccessor
TSwitchAccessor.group = {}

local function TSwitchAccessor_from_obj(obj)
    return setmetatable(obj, TSwitchAccessor)
end

function TSwitchAccessor.new(SwitchAccessor)
    return TSwitchAccessor_from_obj({SwitchAccessor = SwitchAccessor})
end
---@param obj MDftJTAG.SwitchAccessor
function TSwitchAccessor:init_from_obj(obj)
    self.SwitchAccessor = obj.SwitchAccessor
end

function TSwitchAccessor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSwitchAccessor.group)
end

TSwitchAccessor.from_obj = TSwitchAccessor_from_obj

TSwitchAccessor.proto_property = {'SwitchAccessor'}

TSwitchAccessor.default = {0}

TSwitchAccessor.struct = {{name = 'SwitchAccessor', is_array = false, struct = nil}}

function TSwitchAccessor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SwitchAccessor', self.SwitchAccessor, 'uint8', false, errs, need_convert)

    TSwitchAccessor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSwitchAccessor.proto_property, errs, need_convert)
    return self
end

function TSwitchAccessor:unpack(_)
    return self.SwitchAccessor
end

MDftJTAG.SwitchAccessor = TSwitchAccessor

return MDftJTAG
