-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftCpld = {}

---@class MDftCpld.Count
---@field Count integer
local TCount = {}
TCount.__index = TCount
TCount.group = {}

local function TCount_from_obj(obj)
    return setmetatable(obj, TCount)
end

function TCount.new(Count)
    return TCount_from_obj({Count = Count or 0})
end
---@param obj MDftCpld.Count
function TCount:init_from_obj(obj)
    self.Count = obj.Count or 0
end

function TCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCount.group)
end

TCount.from_obj = TCount_from_obj

TCount.proto_property = {'Count'}

TCount.default = {0}

TCount.struct = {{name = 'Count', is_array = false, struct = nil}}

function TCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCount.proto_property, errs, need_convert)
    return self
end

function TCount:unpack(_)
    return self.Count
end

MDftCpld.Count = TCount

---@class MDftCpld.CpldStatus
---@field CpldStatus integer
local TCpldStatus = {}
TCpldStatus.__index = TCpldStatus
TCpldStatus.group = {}

local function TCpldStatus_from_obj(obj)
    return setmetatable(obj, TCpldStatus)
end

function TCpldStatus.new(CpldStatus)
    return TCpldStatus_from_obj({CpldStatus = CpldStatus})
end
---@param obj MDftCpld.CpldStatus
function TCpldStatus:init_from_obj(obj)
    self.CpldStatus = obj.CpldStatus
end

function TCpldStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldStatus.group)
end

TCpldStatus.from_obj = TCpldStatus_from_obj

TCpldStatus.proto_property = {'CpldStatus'}

TCpldStatus.default = {0}

TCpldStatus.struct = {{name = 'CpldStatus', is_array = false, struct = nil}}

function TCpldStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldStatus', self.CpldStatus, 'uint8', false, errs, need_convert)

    TCpldStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldStatus.proto_property, errs, need_convert)
    return self
end

function TCpldStatus:unpack(_)
    return self.CpldStatus
end

MDftCpld.CpldStatus = TCpldStatus

return MDftCpld
