*openUBMC 支持VRD固件独立升级功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.09</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>mao_0v0</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/7/16</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/7/16</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>mao_0v0</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>VRD</td>
        <td>Voltage Regulator Down</td>
        <td>电压调节器</td>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
    <tr>
        <td>MCU</td>
        <td>Microcontroller Unit</td>
        <td>微控制器单元</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
当前openUBMC系统仅支持VRD作为MCU子固件进行升级，无法实现VRD固件的独立升级管理。这种限制导致以下问题：

1. **升级灵活性不足**：无法针对特定的VRD芯片进行独立升级，必须依赖MCU整体升级流程
2. **维护效率低下**：当某个VRD芯片需要升级时，可能需要先升级整个MCU固件，增加了不必要的升级风险
3. **版本管理复杂**：无法精确控制不同VRD芯片的版本，影响系统稳定性和兼容性

该需求将为用户提供更精细化的VRD固件管理能力，提升系统维护的灵活性和安全性。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
本功能主要实现VRD固件的独立升级管理，解决当前VRD固件升级依赖MCU整体升级的问题。具体包括：

1. **独立升级对象**：提供专门的VRD固件升级对象，支持单个或多个VRD芯片的独立升级
2. **升级流程控制**：实现独立VRD固件升级的完整生命周期管理，包括准备、执行、验证和生效
3. **多芯片支持**：支持不同类型VRD芯片的升级，如MP2882等
4. **升级状态监控**：提供升级过程的实时状态监控和结果反馈

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

### 1.3.1 场景触发条件及对象
- **使用角色**：系统管理员、运维人员、技术支持工程师
- **使用工具**：Web管理界面、CLI命令行、IPMI工具、Redfish API等
- **使用技能**：具备基本的BMC管理经验，了解VRD固件升级相关知识

### 1.3.2 使用时间及频度
- **使用时间**：系统维护窗口期、故障修复时、版本更新时
- **使用频度**：低频使用

### 1.3.3 主要场景及子场景

#### 场景1：VRD固件版本升级
- 单个VRD芯片升级

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| F001 | VRD固件版本查询 | 支持查询系统中所有VRD芯片的当前固件版本信息，包括版本号、发布日期、兼容性信息等 |
| F002 | VRD固件独立升级 | 支持独立VRD芯片的独立升级，包括升级准备、执行、验证和生效 |
| F003 | VRD固件升级状态监控 | 提供升级过程的实时状态监控，包括进度显示、错误处理和结果反馈 |
| F004 | VRD固件升级历史管理 | 记录和管理VRD固件升级的历史信息，包括升级时间、版本变更、操作人员等 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
```mermaid
classDiagram
    %% 主服务层
    class independent_vrd_service {
        -ind_vrd_collection: table[]
        +init()
        +new()
    }
    
    %% 升级管理层
    class vrd_upgrade {
        -vrd_collection: table[]
        +on_upgrade_prepare()
        +on_upgrade_process()
        +on_upgrade_finish()
        +new()
    }
    
    class upgrade_service_vrd {
        +on_upgrade_prepare()
        +on_upgrade_process()
        +on_upgrade_finish()
        +new()
    }
    
    %% 芯片抽象层
    class smc_mcu_object {
        <<abstract>>
        #interface: object
        +register_firmware_inventory()*
        +init()
    }
    
    %% 具体芯片实现
    class mp2882 {
        +new()
    }
    
    class other_vrd_chip {
        <<future extension>>
        +new()
    }
    
    %% 观察者模式
    class upgrade_subject {
        <<singleton>>
        -upgrade_observers: table
        -active_observers: table
        +new()
    }
    
    %% 子组件管理
    class sub_component {
        +register_vrd_firmware_info(obj, bus)
        +new(index, detail)
    }
    
    %% 基础对象
    class mcu_object_base {
        <<abstract>>
        #object: table
        +insert_subcomp_detail(component)
    }

    %% 继承关系
    smc_mcu_object --|> mcu_object_base
    mp2882 --|> smc_mcu_object
    
    %% 组合关系
    independent_vrd_service "1" *-- "1" vrd_upgrade : contains
    vrd_upgrade "1" *-- "1" upgrade_service_vrd : delegates
    independent_vrd_service "1" o-- "*" mp2882 : manages
    independent_vrd_service "1" o-- "*" other_vrd_chip : manages
    smc_mcu_object "1" o-- "*" sub_component : manages
    
    %% 观察者模式关系
    upgrade_subject "1" o-- "*" vrd_upgrade : observes
    
    %% 配置数据
    class VRDFirmware_Config {
        <<configuration>>
        +RefChip: U8[]
        +ChipType: string
    }
    
    VRDFirmware_Config ..> independent_vrd_service : configures
```

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

```mermaid
graph TB
    subgraph "外部接口层"
        J[Web API] --> F
        K[CLI] --> F
        L[IPMI] --> F
        M[Redfish] --> F
    end
    
    subgraph "firmware_mgmt组件"
        F[firmware_mgmt] --> G[upgrade_manager]
        G --> H[version_manager]
        G --> I[package_manager]
    end
    
    subgraph "upgrade_subject - 观察者框架"
        E[upgrade_subject]
    end
    
    subgraph "general_hardware组件"
        subgraph "主要服务"
            A[independent_vrd_service]
            VU[vrd_upgrade]
            USV[upgrade_service_vrd]
        end
        
        subgraph "芯片实现"
            B[mp2882]
            C[other_vrd_chip]
            D[smc_mcu_object]
        end
        
        subgraph "子组件"
            SC[sub_component]
        end
        
        A --> VU
        VU --> USV
        A --> B
        A --> C
        B --> D
        D --> SC
    end
    
    F --> E
    E --> VU
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
流程与mcu下vrd升级保持一致

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
需cpld为天池架构且SMC已支持支持升级

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 不涉及新增 | NA | NA | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不影响以前Vrd升级

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

| 用例编号 | 用例名称 | 用例描述 | 前置条件 | 执行步骤 | 预期结果 |
| ------- | ------- | ------- | ------- | ------- | ------- |
| 1 | VRD固件版本查询 | 查询系统中所有VRD芯片的当前固件版本 | 系统正常运行 | 1. 调用版本查询接口<br>2. 解析返回结果 | 返回所有VRD芯片的版本信息 |
| 2 | VRD在os下电升级 | 对指定的VRD芯片进行固件升级 | 升级包已上传且验证通过 | 1. 选择目标VRD芯片<br>2. 执行升级操作<br>3. 监控升级进度<br>4. 验证升级结果 | VRD芯片升级成功，版本更新 |
| 3 | VRD固件升级失败处理 | 处理VRD固件升级失败的情况 | 升级过程中发生错误 | 1. 检测升级失败<br>2. 记录错误信息 | 升级报错 |
| 4 | VRD在os上电升级下电生效 | os上电升级返回成功但是实际下电才生效 | os上电| 1. os上电升级VRD固件<br>2. 执行os下电<br>3. VRD生效 | VRD生效成功 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

本设计采用模块化和可扩展的架构，具有良好的扩展性：

1. **芯片类型扩展**：
   - 基于`smc_mcu_object`抽象基类的继承体系，添加新VRD芯片只需继承该基类并实现自己的方法
   - 通过`ChipType`配置字段自动加载对应的芯片实现类，支持运行时动态扩展
   - 芯片实现类遵循统一的接口规范，降低集成复杂度

2. **升级策略扩展**：
   - 采用委托模式，`vrd_upgrade`类委托给`upgrade_service_vrd`处理具体升级逻辑
   - 升级服务可以独立演进，不影响上层接口

3. **接口扩展**：
   - 基于观察者模式的`upgrade_subject`，支持多个观察者订阅升级事件
   - 统一的升级接口设计（prepare、process、finish、active），便于扩展新的升级阶段
   - 支持不同固件类型的升级管理

4. **功能扩展**：
   - 通过观察者模式，可以灵活添加新的升级事件处理逻辑而不修改核心代码
   - 子组件管理机制支持复杂的固件结构扩展
   - 配置驱动的设计，通过修改配置即可支持新的硬件平台

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

本设计具有良好的重用性：

1. **通用接口**：
   - `upgrade_subject`观察者模式框架可被其他升级功能重用

2. **升级框架**：
   - `upgrade_service_vrd`提供的升级流程框架可被其他VRD相关功能重用
   - 升级状态跟踪和错误处理机制具有通用性

3. **配置管理**：
   - 基于ChipType的动态加载机制可被其他硬件配置功能重用

4. **事件机制**：
   - 观察者模式的事件分发机制可被其他功能模块重用
   - 信号（signal）机制提供松耦合的事件通知，具有通用性
   - 子组件管理机制可被其他复杂硬件管理功能重用

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->

可直接验证，按照测试用例覆盖测试

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

**资源使用分析：**

1. **线程使用**：
   - 新增1个VRD升级服务线程，占用资源较少
   - 升级过程中可能临时创建通信线程，升级完成后释放

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | DC场景 | os下电升级过程中尝试给os上电影响os | 中等 | 中 | 实现上电锁禁止os上电 | 已讨论，需要实现 |  | |
| 2 | AC场景 | VRD上电升级完成后直接AC | 中等 | 中 | 上电升级缓存升级包，以及数据库。AC后下电触发生效 | 已讨论，需要实现 |  | |
| 3 | 数据获取异常状态 | 硬件通信异常导致升级失败 | 高 | 高 | 实现重试机制和超时处理 | 已讨论，需要实现 |  |  |

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | 固件管理通用权限控制 |
| 敏感数据 | 否 | 不涉及敏感数据处理 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 是 | 1. 记录所有升级操作日志<br>2. 记录升级失败和异常日志 |
| 文档 | 否 | 不涉及文档安全 |
| 加密及算法 | 否 | 不涉及加密算法 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 不涉及密钥证书管理 |
| 新增对外接口入参校验 | 否 | 不涉及 |
| 新增开源及三方软件引入 | 否 | 不涉及新的开源软件引入 |

# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】支持VRD固件独立升级功能实现
### 3.1.1 功能实现设计
新增类，用于独立VRD管理
```json
"VRDFirmware_xxx": {
    "UID":"String",                     // 天池架构使用，说明属于哪个单板
    "BoardType": "String",              // 天池架构使用，说明属于哪个单板
    "SoftwareId": "String",             // 固定格式用于展示
    "RefChip": "U8[]",                  // 升级关联chip
    "ChipType": "String",               // 芯片类型，指定加载升级步骤。
    // "VrdId":"String",                   根据id顺序排序,一个vrd配置一个
    // "ExpectFirmwareVersion": "U32",     // vrd预期版本
    // "RecoverChip": "U8[]",              // 恢复芯片
    // "UpdateFlag": "U8",                 // 说明是否已升过级，持久化
}
```
新增类，用于独立VRD管理
### 3.1.2 功能详细设计

#### 3.1.2.1 升级流程详细设计

**升级执行阶段流程：**
```mermaid
flowchart TD
    A[开始升级执行] --> B[获取芯片实例]
    B --> C[初始化通信通道]
    C --> D{初始化成功?}
    D -->|否| E[记录错误并返回]
    D -->|是| F[发送升级包]
    F --> G{发送成功?}
    G -->|否| H[重试发送]
    H --> I{重试次数超限?}
    I -->|是| J[记录错误并返回]
    I -->|否| F
    G -->|是| K[等待升级完成]
    K --> L{升级成功?}
    L -->|是| P[更新版本信息]
    L -->|否| R[返回升级失败]
    P --> Q[返回升级成功]
```

### 3.1.3 开发者测试

#### 3.1.3.1 单元测试

**测试用例设计：**
```
test/unit/vrd/
├── init.lua
├── independent_vrd/
│   ├── chip/
│   │   ├── test_mp2882.lua
│   │   └── test_vrd_upgrade.lua
│   └── test_ind_vrd_service.lua
└── vrd/
    └── chip/
        └── test_vrd_chip_service.lua
```

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->