# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
from conanbase import ConanBase, copy, os
from conan.tools.files import chdir

required_conan_version = ">=1.60.0"


class AppConan(ConanBase):
    def check_path_is_existed(self, path):
        """检查路径是否存在, 如果不存在则抛出异常"""
        if not os.path.exists(path):
            raise FileNotFoundError(f"文件不存在: {path}")
        return True

    def build(self):
        if self.options.qemu:
            self.output.info("build option qemu start")
            with chdir(self, self.source_folder):
                try:
                    self.__sed_unit_lua()
                except FileNotFoundError as e:
                    self.output.error(f"错误: {e}")
                    raise

        super().build()

    def package(self):
        super().package()
        copy(self, "permissions.ini", src=os.path.join(self.source_folder, "dist"), dst=self.package_folder)


    def package_info(self):
        pass

    def __sed_unit_lua(self):
        des = "src/lualib/unit_manager/class/unit/unit.lua"
        # 检查文件是否存在, 如果不存在会抛出异常
        if self.check_path_is_existed(des):
            self.run("sed -i 's/skynet.sleep(100)/skynet.sleep(1000)/g' {}".format(des))
            self.run("sed -i 's/skynet.sleep(200)/skynet.sleep(2000)/g' {}".format(des))