-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local Class = require 'mc.class'
local lu = require 'luaunit'

---@class cpld_mock
local cpld_mock = Class()

function cpld_mock:new()
    return cpld_mock
end

function cpld_mock:config_jtag_gpio(tck_gpio, tms_gpio, tdo_gpio, tdi_gpio)
    lu.assertEquals(tck_gpio, 67)
    lu.assertEquals(tms_gpio, 68)
    lu.assertEquals(tdo_gpio, 69)
    lu.assertEquals(tdi_gpio, 70)
end


function cpld_mock:reset_init(gpio)
    lu.assertEquals(gpio, 56)
end

function cpld_mock:config_jtag_reg(localbus_offset, tck_bit, tms_bit, tdo_bit, tdi_bit)
    lu.assertEquals(localbus_offset, 32)
    lu.assertEquals(tck_bit, 3)
    lu.assertEquals(tms_bit, 2)
    lu.assertEquals(tdo_bit, 0)
    lu.assertEquals(tdi_bit, 1)
end


function cpld_mock:jtag_write(data, component_id, product_id)
    lu.assertEquals(product_id, 0x10)
    lu.assertEquals(data, '\x12\x56\x1f\x11\x17\x10\x05\x11\x7a\x1b\x43\x03\x02\x14\x15\x10\x20\x30\x33\x40')
end

function cpld_mock:reset()
end

function cpld_mock:get_id(select, cpld_id)
    return {35899, 35899}
end

function cpld_mock:set_num(number)
    lu.assertEquals(number, 0)
end

function cpld_mock:set_bypass(enable)
    lu.assertEquals(enable, true)
end

return cpld_mock