-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local db_selector = {}

---@class PersistPoweroffTable: Table
---@field PerId FieldBase
---@field Key FieldBase
---@field Value FieldBase

---@class FrudataDBDatabasePoweroff
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field PersistPoweroff PersistPoweroffTable

local FrudataDBDatabasePoweroff = {}
FrudataDBDatabasePoweroff.__index = FrudataDBDatabasePoweroff

function FrudataDBDatabasePoweroff.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.PersistPoweroff = db:Table('t_frudata_poweroff', {
        PerId = Col.TextField():cid(1):primary_key(),
        Key = Col.TextField():cid(2):primary_key(),
        Value = Col.TextField():cid(3):null()
    }):create_if_not_exist(datas and datas['t_frudata_poweroff'])

    obj.tables = db.tables
    return setmetatable(obj, FrudataDBDatabasePoweroff)
end

function FrudataDBDatabasePoweroff:select(table, ...)
    return self.db:select(table, ...)
end

function FrudataDBDatabasePoweroff:update(table, ...)
    return self.db:update(table, ...)
end

function FrudataDBDatabasePoweroff:insert(table, ...)
    return self.db:insert(table, ...)
end

function FrudataDBDatabasePoweroff:delete(table, ...)
    return self.db:delete(table, ...)
end

function FrudataDBDatabasePoweroff:exec(...)
    return self.db:exec(...)
end

db_selector['poweroff'] = FrudataDBDatabasePoweroff.new

local FrudataDBDatabase = {}
FrudataDBDatabase.__index = FrudataDBDatabase

function FrudataDBDatabase.new(path, datas, type)
    return db_selector[type] and db_selector[type](path, datas) or nil
end

return FrudataDBDatabase.new
