-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Product = {}

---@class Product.ProductCustomInfo
---@field ProductCustomInfo string
local TProductCustomInfo = {}
TProductCustomInfo.__index = TProductCustomInfo
TProductCustomInfo.group = {}

local function TProductCustomInfo_from_obj(obj)
    return setmetatable(obj, TProductCustomInfo)
end

function TProductCustomInfo.new(ProductCustomInfo)
    return TProductCustomInfo_from_obj({ProductCustomInfo = ProductCustomInfo})
end
---@param obj Product.ProductCustomInfo
function TProductCustomInfo:init_from_obj(obj)
    self.ProductCustomInfo = obj.ProductCustomInfo
end

function TProductCustomInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductCustomInfo.group)
end

TProductCustomInfo.from_obj = TProductCustomInfo_from_obj

TProductCustomInfo.proto_property = {'ProductCustomInfo'}

TProductCustomInfo.default = {''}

TProductCustomInfo.struct = {{name = 'ProductCustomInfo', is_array = false, struct = nil}}

function TProductCustomInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductCustomInfo', self.ProductCustomInfo, 'string', true, errs, need_convert)

    TProductCustomInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductCustomInfo.proto_property, errs, need_convert)
    return self
end

function TProductCustomInfo:unpack(_)
    return self.ProductCustomInfo
end

Product.ProductCustomInfo = TProductCustomInfo

---@class Product.ProductFRUFileID
---@field ProductFRUFileID string
local TProductFRUFileID = {}
TProductFRUFileID.__index = TProductFRUFileID
TProductFRUFileID.group = {}

local function TProductFRUFileID_from_obj(obj)
    return setmetatable(obj, TProductFRUFileID)
end

function TProductFRUFileID.new(ProductFRUFileID)
    return TProductFRUFileID_from_obj({ProductFRUFileID = ProductFRUFileID})
end
---@param obj Product.ProductFRUFileID
function TProductFRUFileID:init_from_obj(obj)
    self.ProductFRUFileID = obj.ProductFRUFileID
end

function TProductFRUFileID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductFRUFileID.group)
end

TProductFRUFileID.from_obj = TProductFRUFileID_from_obj

TProductFRUFileID.proto_property = {'ProductFRUFileID'}

TProductFRUFileID.default = {''}

TProductFRUFileID.struct = {{name = 'ProductFRUFileID', is_array = false, struct = nil}}

function TProductFRUFileID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductFRUFileID', self.ProductFRUFileID, 'string', true, errs, need_convert)

    TProductFRUFileID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductFRUFileID.proto_property, errs, need_convert)
    return self
end

function TProductFRUFileID:unpack(_)
    return self.ProductFRUFileID
end

Product.ProductFRUFileID = TProductFRUFileID

---@class Product.AssetTag
---@field AssetTag string
local TAssetTag = {}
TAssetTag.__index = TAssetTag
TAssetTag.group = {}

local function TAssetTag_from_obj(obj)
    return setmetatable(obj, TAssetTag)
end

function TAssetTag.new(AssetTag)
    return TAssetTag_from_obj({AssetTag = AssetTag})
end
---@param obj Product.AssetTag
function TAssetTag:init_from_obj(obj)
    self.AssetTag = obj.AssetTag
end

function TAssetTag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssetTag.group)
end

TAssetTag.from_obj = TAssetTag_from_obj

TAssetTag.proto_property = {'AssetTag'}

TAssetTag.default = {''}

TAssetTag.struct = {{name = 'AssetTag', is_array = false, struct = nil}}

function TAssetTag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssetTag', self.AssetTag, 'string', true, errs, need_convert)

    TAssetTag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssetTag.proto_property, errs, need_convert)
    return self
end

function TAssetTag:unpack(_)
    return self.AssetTag
end

Product.AssetTag = TAssetTag

---@class Product.ProductSerialNumber
---@field ProductSerialNumber string
local TProductSerialNumber = {}
TProductSerialNumber.__index = TProductSerialNumber
TProductSerialNumber.group = {}

local function TProductSerialNumber_from_obj(obj)
    return setmetatable(obj, TProductSerialNumber)
end

function TProductSerialNumber.new(ProductSerialNumber)
    return TProductSerialNumber_from_obj({ProductSerialNumber = ProductSerialNumber})
end
---@param obj Product.ProductSerialNumber
function TProductSerialNumber:init_from_obj(obj)
    self.ProductSerialNumber = obj.ProductSerialNumber
end

function TProductSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductSerialNumber.group)
end

TProductSerialNumber.from_obj = TProductSerialNumber_from_obj

TProductSerialNumber.proto_property = {'ProductSerialNumber'}

TProductSerialNumber.default = {''}

TProductSerialNumber.struct = {{name = 'ProductSerialNumber', is_array = false, struct = nil}}

function TProductSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductSerialNumber', self.ProductSerialNumber, 'string', true, errs, need_convert)

    TProductSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductSerialNumber.proto_property, errs, need_convert)
    return self
end

function TProductSerialNumber:unpack(_)
    return self.ProductSerialNumber
end

Product.ProductSerialNumber = TProductSerialNumber

---@class Product.ProductVersion
---@field ProductVersion string
local TProductVersion = {}
TProductVersion.__index = TProductVersion
TProductVersion.group = {}

local function TProductVersion_from_obj(obj)
    return setmetatable(obj, TProductVersion)
end

function TProductVersion.new(ProductVersion)
    return TProductVersion_from_obj({ProductVersion = ProductVersion})
end
---@param obj Product.ProductVersion
function TProductVersion:init_from_obj(obj)
    self.ProductVersion = obj.ProductVersion
end

function TProductVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductVersion.group)
end

TProductVersion.from_obj = TProductVersion_from_obj

TProductVersion.proto_property = {'ProductVersion'}

TProductVersion.default = {''}

TProductVersion.struct = {{name = 'ProductVersion', is_array = false, struct = nil}}

function TProductVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductVersion', self.ProductVersion, 'string', true, errs, need_convert)

    TProductVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductVersion.proto_property, errs, need_convert)
    return self
end

function TProductVersion:unpack(_)
    return self.ProductVersion
end

Product.ProductVersion = TProductVersion

---@class Product.ProductPartNumber
---@field ProductPartNumber string
local TProductPartNumber = {}
TProductPartNumber.__index = TProductPartNumber
TProductPartNumber.group = {}

local function TProductPartNumber_from_obj(obj)
    return setmetatable(obj, TProductPartNumber)
end

function TProductPartNumber.new(ProductPartNumber)
    return TProductPartNumber_from_obj({ProductPartNumber = ProductPartNumber})
end
---@param obj Product.ProductPartNumber
function TProductPartNumber:init_from_obj(obj)
    self.ProductPartNumber = obj.ProductPartNumber
end

function TProductPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductPartNumber.group)
end

TProductPartNumber.from_obj = TProductPartNumber_from_obj

TProductPartNumber.proto_property = {'ProductPartNumber'}

TProductPartNumber.default = {''}

TProductPartNumber.struct = {{name = 'ProductPartNumber', is_array = false, struct = nil}}

function TProductPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductPartNumber', self.ProductPartNumber, 'string', true, errs, need_convert)

    TProductPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductPartNumber.proto_property, errs, need_convert)
    return self
end

function TProductPartNumber:unpack(_)
    return self.ProductPartNumber
end

Product.ProductPartNumber = TProductPartNumber

---@class Product.ProductName
---@field ProductName string
local TProductName = {}
TProductName.__index = TProductName
TProductName.group = {}

local function TProductName_from_obj(obj)
    return setmetatable(obj, TProductName)
end

function TProductName.new(ProductName)
    return TProductName_from_obj({ProductName = ProductName})
end
---@param obj Product.ProductName
function TProductName:init_from_obj(obj)
    self.ProductName = obj.ProductName
end

function TProductName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductName.group)
end

TProductName.from_obj = TProductName_from_obj

TProductName.proto_property = {'ProductName'}

TProductName.default = {''}

TProductName.struct = {{name = 'ProductName', is_array = false, struct = nil}}

function TProductName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductName', self.ProductName, 'string', true, errs, need_convert)

    TProductName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductName.proto_property, errs, need_convert)
    return self
end

function TProductName:unpack(_)
    return self.ProductName
end

Product.ProductName = TProductName

---@class Product.ManufacturerName
---@field ManufacturerName string
local TManufacturerName = {}
TManufacturerName.__index = TManufacturerName
TManufacturerName.group = {}

local function TManufacturerName_from_obj(obj)
    return setmetatable(obj, TManufacturerName)
end

function TManufacturerName.new(ManufacturerName)
    return TManufacturerName_from_obj({ManufacturerName = ManufacturerName})
end
---@param obj Product.ManufacturerName
function TManufacturerName:init_from_obj(obj)
    self.ManufacturerName = obj.ManufacturerName
end

function TManufacturerName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturerName.group)
end

TManufacturerName.from_obj = TManufacturerName_from_obj

TManufacturerName.proto_property = {'ManufacturerName'}

TManufacturerName.default = {''}

TManufacturerName.struct = {{name = 'ManufacturerName', is_array = false, struct = nil}}

function TManufacturerName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerName', self.ManufacturerName, 'string', true, errs, need_convert)

    TManufacturerName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturerName.proto_property, errs, need_convert)
    return self
end

function TManufacturerName:unpack(_)
    return self.ManufacturerName
end

Product.ManufacturerName = TManufacturerName

Product.interface = mdb.register_interface('bmc.kepler.Systems.FruData.Product', {
    ManufacturerName = {'s', nil, true, nil, false},
    ProductName = {'s', nil, true, nil, false},
    ProductPartNumber = {'s', nil, true, nil, false},
    ProductVersion = {'s', {}, true, nil, false},
    ProductSerialNumber = {'s', nil, true, nil, false},
    AssetTag = {'s', nil, true, nil, false},
    ProductFRUFileID = {'s', {}, true, nil, false},
    ProductCustomInfo = {'s', {}, true, nil, false}
}, {}, {})

return Product
