-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FruDatas = {}

---@class FruDatas.GetFruDataListReq
local TGetFruDataListReq = {}
TGetFruDataListReq.__index = TGetFruDataListReq
TGetFruDataListReq.group = {}

local function TGetFruDataListReq_from_obj(obj)
    return setmetatable(obj, TGetFruDataListReq)
end

function TGetFruDataListReq.new()
    return TGetFruDataListReq_from_obj({})
end
---@param obj FruDatas.GetFruDataListReq
function TGetFruDataListReq:init_from_obj(obj)

end

function TGetFruDataListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruDataListReq.group)
end

TGetFruDataListReq.from_obj = TGetFruDataListReq_from_obj

TGetFruDataListReq.proto_property = {}

TGetFruDataListReq.default = {}

TGetFruDataListReq.struct = {}

function TGetFruDataListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetFruDataListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruDataListReq.proto_property, errs, need_convert)
    return self
end

function TGetFruDataListReq:unpack(_)
end

FruDatas.GetFruDataListReq = TGetFruDataListReq

---@class FruDatas.Item
---@field key string
---@field value string
local TItem = {}
TItem.__index = TItem
TItem.group = {}

local function TItem_from_obj(obj)
    return setmetatable(obj, TItem)
end

function TItem.new(dict)
    return TItem_from_obj(dict)
end

---@param obj FruDatas.Item
function TItem:init_from_obj(obj)
    self = obj
end

function TItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TItem.group)
end

TItem.from_obj = TItem_from_obj

TItem.proto_property = {}

TItem.default = {}

TItem.struct = {}

function TItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TItem:remove_error_props(errs, self)
    return self
end

function TItem:unpack(_)
    return self
end

FruDatas.Item = TItem

---@class FruDatas.FruDataItems
---@field Items FruDatas.Item
local TFruDataItems = {}
TFruDataItems.__index = TFruDataItems
TFruDataItems.group = {}

local function TFruDataItems_from_obj(obj)
    return setmetatable(obj, TFruDataItems)
end

function TFruDataItems.new(Items)
    return TFruDataItems_from_obj({Items = Items})
end
---@param obj FruDatas.FruDataItems
function TFruDataItems:init_from_obj(obj)
    self.Items = obj.Items
end

function TFruDataItems:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruDataItems.group)
end

TFruDataItems.from_obj = TFruDataItems_from_obj

TFruDataItems.proto_property = {'Items'}

TFruDataItems.default = {FruDatas.Item.default}

TFruDataItems.struct = {{name = 'Items', is_array = false, struct = FruDatas.Item.struct}}

function TFruDataItems:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FruDatas.Item.new(self.Items):validate(prefix, errs, need_convert)

    TFruDataItems:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruDataItems.proto_property, errs, need_convert)
    return self
end

function TFruDataItems:unpack(_)
    return self.Items
end

FruDatas.FruDataItems = TFruDataItems

---@class FruDatas.GetFruDataListRsp
---@field FruDataList FruDatas.FruDataItems[]
local TGetFruDataListRsp = {}
TGetFruDataListRsp.__index = TGetFruDataListRsp
TGetFruDataListRsp.group = {}

local function TGetFruDataListRsp_from_obj(obj)
    obj.FruDataList = utils.from_obj(FruDatas.FruDataItems, obj.FruDataList, true)
    return setmetatable(obj, TGetFruDataListRsp)
end

function TGetFruDataListRsp.new(FruDataList)
    return TGetFruDataListRsp_from_obj({FruDataList = FruDataList})
end
---@param obj FruDatas.GetFruDataListRsp
function TGetFruDataListRsp:init_from_obj(obj)
    self.FruDataList = obj.FruDataList
end

function TGetFruDataListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFruDataListRsp.group)
end

TGetFruDataListRsp.from_obj = TGetFruDataListRsp_from_obj

TGetFruDataListRsp.proto_property = {'FruDataList'}

TGetFruDataListRsp.default = {{}}

TGetFruDataListRsp.struct = {{name = 'FruDataList', is_array = true, struct = FruDatas.FruDataItems.struct}}

function TGetFruDataListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.FruDataList) do
        FruDatas.FruDataItems.new(v.Items):validate(prefix, errs, need_convert)
    end

    TGetFruDataListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFruDataListRsp.proto_property, errs, need_convert)
    return self
end

function TGetFruDataListRsp:unpack(raw)
    return utils.unpack(raw, self.FruDataList, true)
end

FruDatas.GetFruDataListRsp = TGetFruDataListRsp

FruDatas.interface = mdb.register_interface('bmc.kepler.Chassis.FruDatas', {}, {
    GetFruDataList = {'a{ss}', 'a(a{ss})', TGetFruDataListReq, TGetFruDataListRsp}
}, {})

return FruDatas
