-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Chassis = {}

---@class Chassis.ChassisCustomInfo
---@field ChassisCustomInfo string
local TChassisCustomInfo = {}
TChassisCustomInfo.__index = TChassisCustomInfo
TChassisCustomInfo.group = {}

local function TChassisCustomInfo_from_obj(obj)
    return setmetatable(obj, TChassisCustomInfo)
end

function TChassisCustomInfo.new(ChassisCustomInfo)
    return TChassisCustomInfo_from_obj({ChassisCustomInfo = ChassisCustomInfo})
end
---@param obj Chassis.ChassisCustomInfo
function TChassisCustomInfo:init_from_obj(obj)
    self.ChassisCustomInfo = obj.ChassisCustomInfo
end

function TChassisCustomInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisCustomInfo.group)
end

TChassisCustomInfo.from_obj = TChassisCustomInfo_from_obj

TChassisCustomInfo.proto_property = {'ChassisCustomInfo'}

TChassisCustomInfo.default = {''}

TChassisCustomInfo.struct = {{name = 'ChassisCustomInfo', is_array = false, struct = nil}}

function TChassisCustomInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisCustomInfo', self.ChassisCustomInfo, 'string', true, errs, need_convert)

    TChassisCustomInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisCustomInfo.proto_property, errs, need_convert)
    return self
end

function TChassisCustomInfo:unpack(_)
    return self.ChassisCustomInfo
end

Chassis.ChassisCustomInfo = TChassisCustomInfo

---@class Chassis.ChassisSerialNumber
---@field ChassisSerialNumber string
local TChassisSerialNumber = {}
TChassisSerialNumber.__index = TChassisSerialNumber
TChassisSerialNumber.group = {}

local function TChassisSerialNumber_from_obj(obj)
    return setmetatable(obj, TChassisSerialNumber)
end

function TChassisSerialNumber.new(ChassisSerialNumber)
    return TChassisSerialNumber_from_obj({ChassisSerialNumber = ChassisSerialNumber})
end
---@param obj Chassis.ChassisSerialNumber
function TChassisSerialNumber:init_from_obj(obj)
    self.ChassisSerialNumber = obj.ChassisSerialNumber
end

function TChassisSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisSerialNumber.group)
end

TChassisSerialNumber.from_obj = TChassisSerialNumber_from_obj

TChassisSerialNumber.proto_property = {'ChassisSerialNumber'}

TChassisSerialNumber.default = {''}

TChassisSerialNumber.struct = {{name = 'ChassisSerialNumber', is_array = false, struct = nil}}

function TChassisSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisSerialNumber', self.ChassisSerialNumber, 'string', true, errs, need_convert)

    TChassisSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisSerialNumber.proto_property, errs, need_convert)
    return self
end

function TChassisSerialNumber:unpack(_)
    return self.ChassisSerialNumber
end

Chassis.ChassisSerialNumber = TChassisSerialNumber

---@class Chassis.ChassisPartNumber
---@field ChassisPartNumber string
local TChassisPartNumber = {}
TChassisPartNumber.__index = TChassisPartNumber
TChassisPartNumber.group = {}

local function TChassisPartNumber_from_obj(obj)
    return setmetatable(obj, TChassisPartNumber)
end

function TChassisPartNumber.new(ChassisPartNumber)
    return TChassisPartNumber_from_obj({ChassisPartNumber = ChassisPartNumber})
end
---@param obj Chassis.ChassisPartNumber
function TChassisPartNumber:init_from_obj(obj)
    self.ChassisPartNumber = obj.ChassisPartNumber
end

function TChassisPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisPartNumber.group)
end

TChassisPartNumber.from_obj = TChassisPartNumber_from_obj

TChassisPartNumber.proto_property = {'ChassisPartNumber'}

TChassisPartNumber.default = {''}

TChassisPartNumber.struct = {{name = 'ChassisPartNumber', is_array = false, struct = nil}}

function TChassisPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisPartNumber', self.ChassisPartNumber, 'string', true, errs, need_convert)

    TChassisPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisPartNumber.proto_property, errs, need_convert)
    return self
end

function TChassisPartNumber:unpack(_)
    return self.ChassisPartNumber
end

Chassis.ChassisPartNumber = TChassisPartNumber

---@class Chassis.ChassisType
---@field ChassisType string
local TChassisType = {}
TChassisType.__index = TChassisType
TChassisType.group = {}

local function TChassisType_from_obj(obj)
    return setmetatable(obj, TChassisType)
end

function TChassisType.new(ChassisType)
    return TChassisType_from_obj({ChassisType = ChassisType})
end
---@param obj Chassis.ChassisType
function TChassisType:init_from_obj(obj)
    self.ChassisType = obj.ChassisType
end

function TChassisType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisType.group)
end

TChassisType.from_obj = TChassisType_from_obj

TChassisType.proto_property = {'ChassisType'}

TChassisType.default = {''}

TChassisType.struct = {{name = 'ChassisType', is_array = false, struct = nil}}

function TChassisType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisType', self.ChassisType, 'string', true, errs, need_convert)

    TChassisType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisType.proto_property, errs, need_convert)
    return self
end

function TChassisType:unpack(_)
    return self.ChassisType
end

Chassis.ChassisType = TChassisType

Chassis.interface = mdb.register_interface('bmc.kepler.Systems.FruData.Chassis', {
    ChassisType = {'s', {}, true, nil, false},
    ChassisPartNumber = {'s', nil, true, nil, false},
    ChassisSerialNumber = {'s', {}, true, nil, false},
    ChassisCustomInfo = {'s', {}, true, nil, false}
}, {}, {})

return Chassis
