--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local IpmiWriteFrudata = {}

---@class FrudataIpmiCmds.IpmiWriteFrudataReq
---@field FruDeviceId integer
---@field OffsetLs integer
---@field OffsetMs integer
---@field Data string
local TIpmiWriteFrudataReq = {}
TIpmiWriteFrudataReq.__index = TIpmiWriteFrudataReq
TIpmiWriteFrudataReq.group = {}

local function TIpmiWriteFrudataReq_from_obj(obj)
    return setmetatable(obj, TIpmiWriteFrudataReq)
end

function TIpmiWriteFrudataReq.new(FruDeviceId, OffsetLs, OffsetMs, Data)
    return TIpmiWriteFrudataReq_from_obj({
        FruDeviceId = FruDeviceId,
        OffsetLs = OffsetLs,
        OffsetMs = OffsetMs,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.IpmiWriteFrudataReq
function TIpmiWriteFrudataReq:init_from_obj(obj)
    self.FruDeviceId = obj.FruDeviceId
    self.OffsetLs = obj.OffsetLs
    self.OffsetMs = obj.OffsetMs
    self.Data = obj.Data
end

function TIpmiWriteFrudataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiWriteFrudataReq.group)
end

TIpmiWriteFrudataReq.from_obj = TIpmiWriteFrudataReq_from_obj

TIpmiWriteFrudataReq.proto_property = {'FruDeviceId', 'OffsetLs', 'OffsetMs', 'Data'}

TIpmiWriteFrudataReq.default = {0, 0, 0, ''}

TIpmiWriteFrudataReq.struct = {
    {name = 'FruDeviceId', is_array = false, struct = nil}, {name = 'OffsetLs', is_array = false, struct = nil},
    {name = 'OffsetMs', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TIpmiWriteFrudataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruDeviceId', self.FruDeviceId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OffsetLs', self.OffsetLs, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OffsetMs', self.OffsetMs, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TIpmiWriteFrudataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiWriteFrudataReq.proto_property, errs, need_convert)
    return self
end

function TIpmiWriteFrudataReq:unpack(_)
    return self.FruDeviceId, self.OffsetLs, self.OffsetMs, self.Data
end

IpmiWriteFrudata.IpmiWriteFrudataReq = TIpmiWriteFrudataReq

---@class FrudataIpmiCmds.IpmiWriteFrudataRsp
---@field CompletionCode integer
---@field Count integer
local TIpmiWriteFrudataRsp = {}
TIpmiWriteFrudataRsp.__index = TIpmiWriteFrudataRsp
TIpmiWriteFrudataRsp.group = {}

local function TIpmiWriteFrudataRsp_from_obj(obj)
    return setmetatable(obj, TIpmiWriteFrudataRsp)
end

function TIpmiWriteFrudataRsp.new(CompletionCode, Count)
    return TIpmiWriteFrudataRsp_from_obj({CompletionCode = CompletionCode, Count = Count})
end
---@param obj FrudataIpmiCmds.IpmiWriteFrudataRsp
function TIpmiWriteFrudataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Count = obj.Count
end

function TIpmiWriteFrudataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiWriteFrudataRsp.group)
end

TIpmiWriteFrudataRsp.from_obj = TIpmiWriteFrudataRsp_from_obj

TIpmiWriteFrudataRsp.proto_property = {'CompletionCode', 'Count'}

TIpmiWriteFrudataRsp.default = {0, 0}

TIpmiWriteFrudataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil}
}

function TIpmiWriteFrudataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TIpmiWriteFrudataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiWriteFrudataRsp.proto_property, errs, need_convert)
    return self
end

function TIpmiWriteFrudataRsp:unpack(_)
    return self.CompletionCode, self.Count
end

IpmiWriteFrudata.IpmiWriteFrudataRsp = TIpmiWriteFrudataRsp

return IpmiWriteFrudata
