--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceFunction = {}

---@class FrudataIpmiCmds.GetDeviceFunctionReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceFunctionReq = {}
TGetDeviceFunctionReq.__index = TGetDeviceFunctionReq
TGetDeviceFunctionReq.group = {}

local function TGetDeviceFunctionReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceFunctionReq)
end

function TGetDeviceFunctionReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceFunctionReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceFunctionReq
function TGetDeviceFunctionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceFunctionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceFunctionReq.group)
end

TGetDeviceFunctionReq.from_obj = TGetDeviceFunctionReq_from_obj

TGetDeviceFunctionReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceFunctionReq.default = {0, 0, 0, 0, 0}

TGetDeviceFunctionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceFunctionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceFunctionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceFunctionReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceFunctionReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceFunction.GetDeviceFunctionReq = TGetDeviceFunctionReq

---@class FrudataIpmiCmds.GetDeviceFunctionRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceFunctionRsp = {}
TGetDeviceFunctionRsp.__index = TGetDeviceFunctionRsp
TGetDeviceFunctionRsp.group = {}

local function TGetDeviceFunctionRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceFunctionRsp)
end

function TGetDeviceFunctionRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceFunctionRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceFunctionRsp
function TGetDeviceFunctionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceFunctionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceFunctionRsp.group)
end

TGetDeviceFunctionRsp.from_obj = TGetDeviceFunctionRsp_from_obj

TGetDeviceFunctionRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceFunctionRsp.default = {0, 0, 0, ''}

TGetDeviceFunctionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceFunctionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceFunctionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceFunctionRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceFunctionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceFunction.GetDeviceFunctionRsp = TGetDeviceFunctionRsp

return GetDeviceFunction
