--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceBoardID = {}

---@class FrudataIpmiCmds.GetDeviceBoardIDReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceBoardIDReq = {}
TGetDeviceBoardIDReq.__index = TGetDeviceBoardIDReq
TGetDeviceBoardIDReq.group = {}

local function TGetDeviceBoardIDReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceBoardIDReq)
end

function TGetDeviceBoardIDReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceBoardIDReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceBoardIDReq
function TGetDeviceBoardIDReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceBoardIDReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceBoardIDReq.group)
end

TGetDeviceBoardIDReq.from_obj = TGetDeviceBoardIDReq_from_obj

TGetDeviceBoardIDReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceBoardIDReq.default = {0, 0, 0, 0, 0}

TGetDeviceBoardIDReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceBoardIDReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceBoardIDReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceBoardIDReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceBoardIDReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceBoardID.GetDeviceBoardIDReq = TGetDeviceBoardIDReq

---@class FrudataIpmiCmds.GetDeviceBoardIDRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceBoardIDRsp = {}
TGetDeviceBoardIDRsp.__index = TGetDeviceBoardIDRsp
TGetDeviceBoardIDRsp.group = {}

local function TGetDeviceBoardIDRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceBoardIDRsp)
end

function TGetDeviceBoardIDRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceBoardIDRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceBoardIDRsp
function TGetDeviceBoardIDRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceBoardIDRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceBoardIDRsp.group)
end

TGetDeviceBoardIDRsp.from_obj = TGetDeviceBoardIDRsp_from_obj

TGetDeviceBoardIDRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceBoardIDRsp.default = {0, 0, 0, ''}

TGetDeviceBoardIDRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceBoardIDRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceBoardIDRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceBoardIDRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceBoardIDRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceBoardID.GetDeviceBoardIDRsp = TGetDeviceBoardIDRsp

return GetDeviceBoardID
