--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ComputePowerProperties = {}

---@class FrudataIpmiCmds.ComputePowerPropertiesReq
---@field FruId integer
local TComputePowerPropertiesReq = {}
TComputePowerPropertiesReq.__index = TComputePowerPropertiesReq
TComputePowerPropertiesReq.group = {}

local function TComputePowerPropertiesReq_from_obj(obj)
    return setmetatable(obj, TComputePowerPropertiesReq)
end

function TComputePowerPropertiesReq.new(FruId)
    return TComputePowerPropertiesReq_from_obj({FruId = FruId})
end
---@param obj FrudataIpmiCmds.ComputePowerPropertiesReq
function TComputePowerPropertiesReq:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TComputePowerPropertiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComputePowerPropertiesReq.group)
end

TComputePowerPropertiesReq.from_obj = TComputePowerPropertiesReq_from_obj

TComputePowerPropertiesReq.proto_property = {'FruId'}

TComputePowerPropertiesReq.default = {0}

TComputePowerPropertiesReq.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TComputePowerPropertiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TComputePowerPropertiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComputePowerPropertiesReq.proto_property, errs, need_convert)
    return self
end

function TComputePowerPropertiesReq:unpack(_)
    return self.FruId
end

ComputePowerProperties.ComputePowerPropertiesReq = TComputePowerPropertiesReq

---@class FrudataIpmiCmds.ComputePowerPropertiesRsp
---@field CompletionCode integer
---@field Identifier integer
---@field Slot integer
---@field Location integer
local TComputePowerPropertiesRsp = {}
TComputePowerPropertiesRsp.__index = TComputePowerPropertiesRsp
TComputePowerPropertiesRsp.group = {}

local function TComputePowerPropertiesRsp_from_obj(obj)
    return setmetatable(obj, TComputePowerPropertiesRsp)
end

function TComputePowerPropertiesRsp.new(CompletionCode, Identifier, Slot, Location)
    return TComputePowerPropertiesRsp_from_obj({
        CompletionCode = CompletionCode,
        Identifier = Identifier,
        Slot = Slot,
        Location = Location
    })
end
---@param obj FrudataIpmiCmds.ComputePowerPropertiesRsp
function TComputePowerPropertiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Identifier = obj.Identifier
    self.Slot = obj.Slot
    self.Location = obj.Location
end

function TComputePowerPropertiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComputePowerPropertiesRsp.group)
end

TComputePowerPropertiesRsp.from_obj = TComputePowerPropertiesRsp_from_obj

TComputePowerPropertiesRsp.proto_property = {'CompletionCode', 'Identifier', 'Slot', 'Location'}

TComputePowerPropertiesRsp.default = {0, 0, 0, 0}

TComputePowerPropertiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Identifier', is_array = false, struct = nil},
    {name = 'Slot', is_array = false, struct = nil}, {name = 'Location', is_array = false, struct = nil}
}

function TComputePowerPropertiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Identifier', self.Identifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Location', self.Location, 'uint8', false, errs, need_convert)

    TComputePowerPropertiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComputePowerPropertiesRsp.proto_property, errs, need_convert)
    return self
end

function TComputePowerPropertiesRsp:unpack(_)
    return self.CompletionCode, self.Identifier, self.Slot, self.Location
end

ComputePowerProperties.ComputePowerPropertiesRsp = TComputePowerPropertiesRsp

return ComputePowerProperties
