-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

TestSystemFruCtrlPowerCtrl = {}
function TestSystemFruCtrlPowerCtrl:test_poweron()
    local powerctrl = require 'system_fructrl.power_ctrl'
    local fructrl_proxy = {
        one_host_power_on = function() end
    }
    local host_objs = {
        [1] = {
            fructrl = {
                get_PwrOnLocked = function()
                    return true
                end
            }
        }
    }
    local context = require 'mc.context'
    local ctx_new = context.get_context_or_default()
    local instance_powerctrl = powerctrl.new(fructrl_proxy, host_objs)
    local ok, rsp = pcall(function()
        instance_powerctrl:power_ctrl(1, ctx_new, "On", "Unknown")
    end)
    assert(not ok, rsp)
    ctx_new.requestor = "bmc.kepler.bios"
    ok, rsp = pcall(function()
        instance_powerctrl:power_ctrl(1, ctx_new, "On", "Unknown")
    end)
    assert(ok, rsp)
end