-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local pwr_restore = require 'pwr_restore'
local sys_info = require 'libsoc_adapter.sys_info'

TestPwrRestore = {}

function TestPwrRestore:test_get_chip_name()
    sys_info.new = function ()
        return {
            get_chip_name = function ()
                return '111'
            end,
            close = function()
                return 
            end
        } 
    end

    local ok, ret = pcall(pwr_restore.get_chip_name)
    lu.assertEquals(ok, true)
    lu.assertEquals(ret, "6f")
end