-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

TestIPMI = {}
function TestIPMI:test_pp_ipmi_cmd_chassis_ctrl()
    local cls = require 'pwr_powerctrl_ipmi'
    cls.multihost = {
        is_multihost_type = function()
            return false
        end
    }
    cls.fructrl_obj_mgnt = {
        host_obj = {
            [1] = {
                fructrl = {
                    get_ACCycleEnabled = function() return true end,
                    set_restart_channel = function() end
                },
                powerapi = {
                    system_reset = function() end,
                }
            }
        }
    }
    local ok, rsp = pcall(function()
        cls:pp_ipmi_cmd_chassis_ctrl({Cmd = 0x7}, {chan_num = 1, ChanType = 1})
    end)
    assert(ok, rsp)
    ok, rsp = pcall(function()
        cls:pp_ipmi_cmd_fru_ctrl({PicmgId = 0x00, FruId = 0xff, Option = 0x00}, {HostId = 1})
    end)
    assert(not ok, rsp)
    cls.fructrl_obj_mgnt = {
        host_obj = {
            [1] = {
                fructrl = {
                    get_ACCycleEnabled = function() return false end,
                    set_restart_channel = function() end
                },
                powerapi = {
                    system_reset = function() end
                }
            }
        }
    }
    ok, rsp = pcall(function()
        cls:pp_ipmi_cmd_chassis_ctrl({Cmd = 0x7}, {chan_num = 1, ChanType = 1})
    end)
    assert(not ok, rsp)
end

function TestIPMI:test_pp_ipmi_cmd_set_pwr_restore_policy()
    local cls = require 'pwr_powerctrl_ipmi'
    cls.fructrl_obj_mgnt.chassis_fructrl_ins = {
        set_PowerOnStrategy = function (...)
            return nil
        end
    }
     cls.fructrl_obj_mgnt.host_obj = {
        [1] = {
            fructrl = {
                set_PowerOnStrategy = function (...)
                    return nil
                end
            }
        }
     }
    cls:pp_ipmi_cmd_set_pwr_restore_policy({RestorePolicy = 0}, {HostId = 1})

    cls:pp_ipmi_cmd_set_pwr_restore_policy({RestorePolicy = 1}, {HostId = 1})

    cls:pp_ipmi_cmd_set_pwr_restore_policy({RestorePolicy = 2}, {HostId = 1})

    cls:pp_ipmi_cmd_set_pwr_restore_policy({RestorePolicy = 3}, {HostId = 1})

end