-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local powerctrl = require 'chassis_fructrl.power_ctrl'

TestChassisFruCtrlPowerCtrl = {}

function TestChassisFruCtrlPowerCtrl:test_get_opertaation_success()
    powerctrl.chassis_fructrl_obj = {PowerOnStrategy = 'test'}
    local ok, res = pcall(powerctrl.get_PowerOnStrategy, powerctrl)
    lu.assertEquals(ok, true)
    lu.assertEquals(res, 'test')
end

function TestChassisFruCtrlPowerCtrl:test_get_opertaation_faill()
    powerctrl.chassis_fructrl_obj = nil
    local ok, res= pcall(powerctrl.get_PowerOnStrategy, powerctrl)
    lu.assertEquals(ok, true)
    lu.assertEquals(res, nil)
end

function TestChassisFruCtrlPowerCtrl:test_set_opertaation_success()
    powerctrl.chassis_fructrl_obj = {PowerOnStrategy = 'test'}
    local prop = 1
    local value = 'test'
    local ok, res = pcall(powerctrl.set_PowerOnStrategy, powerctrl, prop, value)
    lu.assertEquals(ok, true)
    lu.assertEquals(res, 0)
end

function TestChassisFruCtrlPowerCtrl:test_set_opertaation_faill()
    powerctrl.chassis_fructrl_obj = nil
    local prop = -5555555555
    local ok, res= pcall(powerctrl.set_PowerOnStrategy, powerctrl, prop)
    lu.assertEquals(ok, true)
    lu.assertEquals(res, -1)
end

function TestChassisFruCtrlPowerCtrl:test_chassis_powewron_init_faill()
    local ok = pcall(powerctrl.init)
    lu.assertEquals(ok, false)
end

function TestChassisFruCtrlPowerCtrl:test_chassis_powewron_init_seccess()
    local m_enums ={
        PowerStatus = {
            OFF= 0,
            ON= 1
        }
    }
    local fructrl_proxy_ins = {
        host_objs = {
            { fructrl = { update_system_poweron_strategy = function (...) print(...) end}},
            { fructrl = { update_system_poweron_strategy = function (...) print(...) end}}
        }
    }
    local chassis_fructrl_obj ={
        PowerOnStategy ='test',
        PowerGDState = 0,
        PowerState = m_enums.PowerStatus.OFF,
        PreviousPowerState = m_enums.PowerStatus.ON,
        property_changed = {
            on = function(self, callback)
                self.callback = callback
            end,
            trugger = function (self, name, value)
                if self.callback then
                    self.callback(name,value)
                end
            end
        }
    }

    chassis_fructrl_obj.PowerGDStatus = 1
    chassis_fructrl_obj.PowerStatus = m_enums.PowerStatus.ON
    chassis_fructrl_obj.PreviousPowerState = m_enums.PowerStatus.ON

    powerctrl.m_enums = m_enums
    powerctrl.fructrl_proxy_ins = fructrl_proxy_ins
    powerctrl.chassis_fructrl_obj = chassis_fructrl_obj

    local ok = pcall(powerctrl.init, powerctrl)
    lu.assertEquals(ok, false)
end


