-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: fructrl multihost test

local skynet = require 'skynet'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'

require 'fructrl.json_types.Multihost'

local cases = {}
local MULTIHOST_INTF<const> = 'bmc.kepler.Managers.Multihost'

local function get_mdb_object(bus, path, intf)
    local mobj
    for _ = 1, 5 do
        mobj = mdb.get_object(bus, path, intf)
        if mobj then
            break
        end
        skynet.sleep(100)
    end
    if not mobj then
        log:error('get mdb object [%s:%s] timeout.', path, intf)
    end
    return mobj
end

local function test_default_multihost(bus)
    log:notice('==> test multihost default start ...')
    local obj = get_mdb_object(bus, '/bmc/kepler/Managers/1/Multihost', MULTIHOST_INTF)
    assert(obj, 'Multihost mdb object does not exist.')
    assert(obj.HostType == 'Multihost', 'actual: ' .. obj.HostType)
    assert(obj.HostCount == 4, 'actual: ' .. obj.HostCount)
    log:notice('==> test multihost default completed ...')
end

function cases.test_entry(bus)
    log:notice('================ test multihost all functions start ================')
    test_default_multihost(bus)
    log:notice('================ test multihost all functions completed ================')
end

return cases