-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 上电超时标志

local log = require 'mc.logging'
local class = require 'mc.class'
local utils = require 'types.utils'

local c_pwr_action = class()

function c_pwr_action:ctor(db, object, id)
    self.db = db
    self.obj = object
    self.system_id = id
    log:notice("[System:%s]set pwr_action object successfully, uptime: %s.", id, utils.uptime())
end

function c_pwr_action:init()
    -- 私有属性属性变更监听
    self.obj.property_changed:on(function(name, value)
        if name == 'PowerOnTimeoutFlag' then
            log:notice('[System:%s]prop PowerOnTimeoutFlag changed to %s', self.system_id, value)
        end
    end)
end

return c_pwr_action