-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SystemLockDown = {}

---@class SystemLockDown.SystemLockDownStatus
---@field SystemLockDownStatus string
local TSystemLockDownStatus = {}
TSystemLockDownStatus.__index = TSystemLockDownStatus
TSystemLockDownStatus.group = {}

local function TSystemLockDownStatus_from_obj(obj)
    return setmetatable(obj, TSystemLockDownStatus)
end

function TSystemLockDownStatus.new(SystemLockDownStatus)
    return TSystemLockDownStatus_from_obj({SystemLockDownStatus = SystemLockDownStatus or [=[Unlocked]=]})
end
---@param obj SystemLockDown.SystemLockDownStatus
function TSystemLockDownStatus:init_from_obj(obj)
    self.SystemLockDownStatus = obj.SystemLockDownStatus or [=[Unlocked]=]
end

function TSystemLockDownStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemLockDownStatus.group)
end

TSystemLockDownStatus.from_obj = TSystemLockDownStatus_from_obj

TSystemLockDownStatus.proto_property = {'SystemLockDownStatus'}

TSystemLockDownStatus.default = {''}

TSystemLockDownStatus.struct = {{name = 'SystemLockDownStatus', is_array = false, struct = nil}}

function TSystemLockDownStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemLockDownStatus', self.SystemLockDownStatus, 'string', false, errs, need_convert)

    if self.SystemLockDownStatus ~= nil then
        validate.Enum(prefix .. 'SystemLockDownStatus', self.SystemLockDownStatus, '', {'Locked', 'Unlocked'}, errs,
            need_convert)
    end

    TSystemLockDownStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemLockDownStatus.proto_property, errs, need_convert)
    return self
end

function TSystemLockDownStatus:unpack(_)
    return self.SystemLockDownStatus
end

SystemLockDown.SystemLockDownStatus = TSystemLockDownStatus

---@class SystemLockDown.SystemLockDownSupport
---@field SystemLockDownSupport string
local TSystemLockDownSupport = {}
TSystemLockDownSupport.__index = TSystemLockDownSupport
TSystemLockDownSupport.group = {}

local function TSystemLockDownSupport_from_obj(obj)
    return setmetatable(obj, TSystemLockDownSupport)
end

function TSystemLockDownSupport.new(SystemLockDownSupport)
    return TSystemLockDownSupport_from_obj({SystemLockDownSupport = SystemLockDownSupport or [=[Unsupported]=]})
end
---@param obj SystemLockDown.SystemLockDownSupport
function TSystemLockDownSupport:init_from_obj(obj)
    self.SystemLockDownSupport = obj.SystemLockDownSupport or [=[Unsupported]=]
end

function TSystemLockDownSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemLockDownSupport.group)
end

TSystemLockDownSupport.from_obj = TSystemLockDownSupport_from_obj

TSystemLockDownSupport.proto_property = {'SystemLockDownSupport'}

TSystemLockDownSupport.default = {''}

TSystemLockDownSupport.struct = {{name = 'SystemLockDownSupport', is_array = false, struct = nil}}

function TSystemLockDownSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemLockDownSupport', self.SystemLockDownSupport, 'string', false, errs, need_convert)

    if self.SystemLockDownSupport ~= nil then
        validate.Enum(prefix .. 'SystemLockDownSupport', self.SystemLockDownSupport, '', {'Supported', 'Unsupported'},
            errs, need_convert)
    end

    TSystemLockDownSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemLockDownSupport.proto_property, errs, need_convert)
    return self
end

function TSystemLockDownSupport:unpack(_)
    return self.SystemLockDownSupport
end

SystemLockDown.SystemLockDownSupport = TSystemLockDownSupport

SystemLockDown.interface = mdb.register_interface('bmc.kepler.Systems.SystemLockDown', {
    SystemLockDownSupport = {'s', {'EMIT_CHANGE'}, false, 'Unsupported', false},
    SystemLockDownStatus = {'s', {'EMIT_CHANGE'}, false, 'Unlocked', false}
}, {}, {})

return SystemLockDown
