-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local SecureBoot = {}

---@class SecureBoot.CertificateHashSignMode: Enum
local ECertificateHashSignMode = create_enum_type('CertificateHashSignMode')
ECertificateHashSignMode.default = ECertificateHashSignMode.new(2147483647)
ECertificateHashSignMode.struct = nil
ECertificateHashSignMode.PKCSSignMode = ECertificateHashSignMode.new(0)
ECertificateHashSignMode.PSSSignMode = ECertificateHashSignMode.new(1)

SecureBoot.CertificateHashSignMode = ECertificateHashSignMode

---@class SecureBoot.ResetOnNextBMCResetRsp
---@field Result boolean
local TResetOnNextBMCResetRsp = {}
TResetOnNextBMCResetRsp.__index = TResetOnNextBMCResetRsp
TResetOnNextBMCResetRsp.group = {}

local function TResetOnNextBMCResetRsp_from_obj(obj)
    return setmetatable(obj, TResetOnNextBMCResetRsp)
end

function TResetOnNextBMCResetRsp.new(Result)
    return TResetOnNextBMCResetRsp_from_obj({Result = Result})
end
---@param obj SecureBoot.ResetOnNextBMCResetRsp
function TResetOnNextBMCResetRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TResetOnNextBMCResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetOnNextBMCResetRsp.group)
end

TResetOnNextBMCResetRsp.from_obj = TResetOnNextBMCResetRsp_from_obj

TResetOnNextBMCResetRsp.proto_property = {'Result'}

TResetOnNextBMCResetRsp.default = {false}

TResetOnNextBMCResetRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TResetOnNextBMCResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'bool', false, errs, need_convert)

    TResetOnNextBMCResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetOnNextBMCResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetOnNextBMCResetRsp:unpack(_)
    return self.Result
end

SecureBoot.ResetOnNextBMCResetRsp = TResetOnNextBMCResetRsp

---@class SecureBoot.ResetOnNextBMCResetReq
local TResetOnNextBMCResetReq = {}
TResetOnNextBMCResetReq.__index = TResetOnNextBMCResetReq
TResetOnNextBMCResetReq.group = {}

local function TResetOnNextBMCResetReq_from_obj(obj)
    return setmetatable(obj, TResetOnNextBMCResetReq)
end

function TResetOnNextBMCResetReq.new()
    return TResetOnNextBMCResetReq_from_obj({})
end
---@param obj SecureBoot.ResetOnNextBMCResetReq
function TResetOnNextBMCResetReq:init_from_obj(obj)

end

function TResetOnNextBMCResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetOnNextBMCResetReq.group)
end

TResetOnNextBMCResetReq.from_obj = TResetOnNextBMCResetReq_from_obj

TResetOnNextBMCResetReq.proto_property = {}

TResetOnNextBMCResetReq.default = {}

TResetOnNextBMCResetReq.struct = {}

function TResetOnNextBMCResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetOnNextBMCResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetOnNextBMCResetReq.proto_property, errs, need_convert)
    return self
end

function TResetOnNextBMCResetReq:unpack(_)
end

SecureBoot.ResetOnNextBMCResetReq = TResetOnNextBMCResetReq

---@class SecureBoot.ExportRepairCredentialsRsp
---@field RepairCredentials integer[]
local TExportRepairCredentialsRsp = {}
TExportRepairCredentialsRsp.__index = TExportRepairCredentialsRsp
TExportRepairCredentialsRsp.group = {}

local function TExportRepairCredentialsRsp_from_obj(obj)
    return setmetatable(obj, TExportRepairCredentialsRsp)
end

function TExportRepairCredentialsRsp.new(RepairCredentials)
    return TExportRepairCredentialsRsp_from_obj({RepairCredentials = RepairCredentials})
end
---@param obj SecureBoot.ExportRepairCredentialsRsp
function TExportRepairCredentialsRsp:init_from_obj(obj)
    self.RepairCredentials = obj.RepairCredentials
end

function TExportRepairCredentialsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportRepairCredentialsRsp.group)
end

TExportRepairCredentialsRsp.from_obj = TExportRepairCredentialsRsp_from_obj

TExportRepairCredentialsRsp.proto_property = {'RepairCredentials'}

TExportRepairCredentialsRsp.default = {{}}

TExportRepairCredentialsRsp.struct = {{name = 'RepairCredentials', is_array = true, struct = nil}}

function TExportRepairCredentialsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RepairCredentials', self.RepairCredentials, 'uint8', false, errs, need_convert)

    TExportRepairCredentialsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportRepairCredentialsRsp.proto_property, errs, need_convert)
    return self
end

function TExportRepairCredentialsRsp:unpack(_)
    return self.RepairCredentials
end

SecureBoot.ExportRepairCredentialsRsp = TExportRepairCredentialsRsp

---@class SecureBoot.ExportRepairCredentialsReq
local TExportRepairCredentialsReq = {}
TExportRepairCredentialsReq.__index = TExportRepairCredentialsReq
TExportRepairCredentialsReq.group = {}

local function TExportRepairCredentialsReq_from_obj(obj)
    return setmetatable(obj, TExportRepairCredentialsReq)
end

function TExportRepairCredentialsReq.new()
    return TExportRepairCredentialsReq_from_obj({})
end
---@param obj SecureBoot.ExportRepairCredentialsReq
function TExportRepairCredentialsReq:init_from_obj(obj)

end

function TExportRepairCredentialsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportRepairCredentialsReq.group)
end

TExportRepairCredentialsReq.from_obj = TExportRepairCredentialsReq_from_obj

TExportRepairCredentialsReq.proto_property = {}

TExportRepairCredentialsReq.default = {}

TExportRepairCredentialsReq.struct = {}

function TExportRepairCredentialsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportRepairCredentialsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportRepairCredentialsReq.proto_property, errs, need_convert)
    return self
end

function TExportRepairCredentialsReq:unpack(_)
end

SecureBoot.ExportRepairCredentialsReq = TExportRepairCredentialsReq

---@class SecureBoot.ImportRepairCredentialsRsp
local TImportRepairCredentialsRsp = {}
TImportRepairCredentialsRsp.__index = TImportRepairCredentialsRsp
TImportRepairCredentialsRsp.group = {}

local function TImportRepairCredentialsRsp_from_obj(obj)
    return setmetatable(obj, TImportRepairCredentialsRsp)
end

function TImportRepairCredentialsRsp.new()
    return TImportRepairCredentialsRsp_from_obj({})
end
---@param obj SecureBoot.ImportRepairCredentialsRsp
function TImportRepairCredentialsRsp:init_from_obj(obj)

end

function TImportRepairCredentialsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportRepairCredentialsRsp.group)
end

TImportRepairCredentialsRsp.from_obj = TImportRepairCredentialsRsp_from_obj

TImportRepairCredentialsRsp.proto_property = {}

TImportRepairCredentialsRsp.default = {}

TImportRepairCredentialsRsp.struct = {}

function TImportRepairCredentialsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportRepairCredentialsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportRepairCredentialsRsp.proto_property, errs, need_convert)
    return self
end

function TImportRepairCredentialsRsp:unpack(_)
end

SecureBoot.ImportRepairCredentialsRsp = TImportRepairCredentialsRsp

---@class SecureBoot.ImportRepairCredentialsReq
---@field RepairCredentials integer[]
local TImportRepairCredentialsReq = {}
TImportRepairCredentialsReq.__index = TImportRepairCredentialsReq
TImportRepairCredentialsReq.group = {}

local function TImportRepairCredentialsReq_from_obj(obj)
    return setmetatable(obj, TImportRepairCredentialsReq)
end

function TImportRepairCredentialsReq.new(RepairCredentials)
    return TImportRepairCredentialsReq_from_obj({RepairCredentials = RepairCredentials})
end
---@param obj SecureBoot.ImportRepairCredentialsReq
function TImportRepairCredentialsReq:init_from_obj(obj)
    self.RepairCredentials = obj.RepairCredentials
end

function TImportRepairCredentialsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportRepairCredentialsReq.group)
end

TImportRepairCredentialsReq.from_obj = TImportRepairCredentialsReq_from_obj

TImportRepairCredentialsReq.proto_property = {'RepairCredentials'}

TImportRepairCredentialsReq.default = {{}}

TImportRepairCredentialsReq.struct = {{name = 'RepairCredentials', is_array = true, struct = nil}}

function TImportRepairCredentialsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RepairCredentials', self.RepairCredentials, 'uint8', false, errs, need_convert)

    TImportRepairCredentialsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportRepairCredentialsReq.proto_property, errs, need_convert)
    return self
end

function TImportRepairCredentialsReq:unpack(_)
    return self.RepairCredentials
end

SecureBoot.ImportRepairCredentialsReq = TImportRepairCredentialsReq

---@class SecureBoot.DisableBootVerificationRsp
local TDisableBootVerificationRsp = {}
TDisableBootVerificationRsp.__index = TDisableBootVerificationRsp
TDisableBootVerificationRsp.group = {}

local function TDisableBootVerificationRsp_from_obj(obj)
    return setmetatable(obj, TDisableBootVerificationRsp)
end

function TDisableBootVerificationRsp.new()
    return TDisableBootVerificationRsp_from_obj({})
end
---@param obj SecureBoot.DisableBootVerificationRsp
function TDisableBootVerificationRsp:init_from_obj(obj)

end

function TDisableBootVerificationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisableBootVerificationRsp.group)
end

TDisableBootVerificationRsp.from_obj = TDisableBootVerificationRsp_from_obj

TDisableBootVerificationRsp.proto_property = {}

TDisableBootVerificationRsp.default = {}

TDisableBootVerificationRsp.struct = {}

function TDisableBootVerificationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDisableBootVerificationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisableBootVerificationRsp.proto_property, errs, need_convert)
    return self
end

function TDisableBootVerificationRsp:unpack(_)
end

SecureBoot.DisableBootVerificationRsp = TDisableBootVerificationRsp

---@class SecureBoot.DisableBootVerificationReq
local TDisableBootVerificationReq = {}
TDisableBootVerificationReq.__index = TDisableBootVerificationReq
TDisableBootVerificationReq.group = {}

local function TDisableBootVerificationReq_from_obj(obj)
    return setmetatable(obj, TDisableBootVerificationReq)
end

function TDisableBootVerificationReq.new()
    return TDisableBootVerificationReq_from_obj({})
end
---@param obj SecureBoot.DisableBootVerificationReq
function TDisableBootVerificationReq:init_from_obj(obj)

end

function TDisableBootVerificationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisableBootVerificationReq.group)
end

TDisableBootVerificationReq.from_obj = TDisableBootVerificationReq_from_obj

TDisableBootVerificationReq.proto_property = {}

TDisableBootVerificationReq.default = {}

TDisableBootVerificationReq.struct = {}

function TDisableBootVerificationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDisableBootVerificationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisableBootVerificationReq.proto_property, errs, need_convert)
    return self
end

function TDisableBootVerificationReq:unpack(_)
end

SecureBoot.DisableBootVerificationReq = TDisableBootVerificationReq

---@class SecureBoot.ExportCustomCertificateHashRsp
---@field CustomCertificateHash integer[]
local TExportCustomCertificateHashRsp = {}
TExportCustomCertificateHashRsp.__index = TExportCustomCertificateHashRsp
TExportCustomCertificateHashRsp.group = {}

local function TExportCustomCertificateHashRsp_from_obj(obj)
    return setmetatable(obj, TExportCustomCertificateHashRsp)
end

function TExportCustomCertificateHashRsp.new(CustomCertificateHash)
    return TExportCustomCertificateHashRsp_from_obj({CustomCertificateHash = CustomCertificateHash})
end
---@param obj SecureBoot.ExportCustomCertificateHashRsp
function TExportCustomCertificateHashRsp:init_from_obj(obj)
    self.CustomCertificateHash = obj.CustomCertificateHash
end

function TExportCustomCertificateHashRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportCustomCertificateHashRsp.group)
end

TExportCustomCertificateHashRsp.from_obj = TExportCustomCertificateHashRsp_from_obj

TExportCustomCertificateHashRsp.proto_property = {'CustomCertificateHash'}

TExportCustomCertificateHashRsp.default = {{}}

TExportCustomCertificateHashRsp.struct = {{name = 'CustomCertificateHash', is_array = true, struct = nil}}

function TExportCustomCertificateHashRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'CustomCertificateHash', self.CustomCertificateHash, 'uint8', false, errs,
        need_convert)

    TExportCustomCertificateHashRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportCustomCertificateHashRsp.proto_property, errs, need_convert)
    return self
end

function TExportCustomCertificateHashRsp:unpack(_)
    return self.CustomCertificateHash
end

SecureBoot.ExportCustomCertificateHashRsp = TExportCustomCertificateHashRsp

---@class SecureBoot.ExportCustomCertificateHashReq
---@field SignMode SecureBoot.CertificateHashSignMode
local TExportCustomCertificateHashReq = {}
TExportCustomCertificateHashReq.__index = TExportCustomCertificateHashReq
TExportCustomCertificateHashReq.group = {}

local function TExportCustomCertificateHashReq_from_obj(obj)
    obj.SignMode = obj.SignMode and SecureBoot.CertificateHashSignMode.new(obj.SignMode)
    return setmetatable(obj, TExportCustomCertificateHashReq)
end

function TExportCustomCertificateHashReq.new(SignMode)
    return TExportCustomCertificateHashReq_from_obj({SignMode = SignMode})
end
---@param obj SecureBoot.ExportCustomCertificateHashReq
function TExportCustomCertificateHashReq:init_from_obj(obj)
    self.SignMode = obj.SignMode
end

function TExportCustomCertificateHashReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportCustomCertificateHashReq.group)
end

TExportCustomCertificateHashReq.from_obj = TExportCustomCertificateHashReq_from_obj

TExportCustomCertificateHashReq.proto_property = {'SignMode'}

TExportCustomCertificateHashReq.default = {SecureBoot.CertificateHashSignMode.default}

TExportCustomCertificateHashReq.struct = {
    {name = 'SignMode', is_array = false, struct = SecureBoot.CertificateHashSignMode.struct}
}

function TExportCustomCertificateHashReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SignMode', self.SignMode, 'SecureBoot.CertificateHashSignMode', false, errs,
        need_convert)

    TExportCustomCertificateHashReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportCustomCertificateHashReq.proto_property, errs, need_convert)
    return self
end

function TExportCustomCertificateHashReq:unpack(raw)
    local SignMode = utils.unpack_enum(raw, self.SignMode)
    return SignMode
end

SecureBoot.ExportCustomCertificateHashReq = TExportCustomCertificateHashReq

---@class SecureBoot.ImportCustomCertificateHashRsp
local TImportCustomCertificateHashRsp = {}
TImportCustomCertificateHashRsp.__index = TImportCustomCertificateHashRsp
TImportCustomCertificateHashRsp.group = {}

local function TImportCustomCertificateHashRsp_from_obj(obj)
    return setmetatable(obj, TImportCustomCertificateHashRsp)
end

function TImportCustomCertificateHashRsp.new()
    return TImportCustomCertificateHashRsp_from_obj({})
end
---@param obj SecureBoot.ImportCustomCertificateHashRsp
function TImportCustomCertificateHashRsp:init_from_obj(obj)

end

function TImportCustomCertificateHashRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCustomCertificateHashRsp.group)
end

TImportCustomCertificateHashRsp.from_obj = TImportCustomCertificateHashRsp_from_obj

TImportCustomCertificateHashRsp.proto_property = {}

TImportCustomCertificateHashRsp.default = {}

TImportCustomCertificateHashRsp.struct = {}

function TImportCustomCertificateHashRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportCustomCertificateHashRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCustomCertificateHashRsp.proto_property, errs, need_convert)
    return self
end

function TImportCustomCertificateHashRsp:unpack(_)
end

SecureBoot.ImportCustomCertificateHashRsp = TImportCustomCertificateHashRsp

---@class SecureBoot.ImportCustomCertificateHashReq
---@field CustomCertificateHash integer[]
local TImportCustomCertificateHashReq = {}
TImportCustomCertificateHashReq.__index = TImportCustomCertificateHashReq
TImportCustomCertificateHashReq.group = {}

local function TImportCustomCertificateHashReq_from_obj(obj)
    return setmetatable(obj, TImportCustomCertificateHashReq)
end

function TImportCustomCertificateHashReq.new(CustomCertificateHash)
    return TImportCustomCertificateHashReq_from_obj({CustomCertificateHash = CustomCertificateHash})
end
---@param obj SecureBoot.ImportCustomCertificateHashReq
function TImportCustomCertificateHashReq:init_from_obj(obj)
    self.CustomCertificateHash = obj.CustomCertificateHash
end

function TImportCustomCertificateHashReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCustomCertificateHashReq.group)
end

TImportCustomCertificateHashReq.from_obj = TImportCustomCertificateHashReq_from_obj

TImportCustomCertificateHashReq.proto_property = {'CustomCertificateHash'}

TImportCustomCertificateHashReq.default = {{}}

TImportCustomCertificateHashReq.struct = {{name = 'CustomCertificateHash', is_array = true, struct = nil}}

function TImportCustomCertificateHashReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'CustomCertificateHash', self.CustomCertificateHash, 'uint8', false, errs,
        need_convert)

    TImportCustomCertificateHashReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCustomCertificateHashReq.proto_property, errs, need_convert)
    return self
end

function TImportCustomCertificateHashReq:unpack(_)
    return self.CustomCertificateHash
end

SecureBoot.ImportCustomCertificateHashReq = TImportCustomCertificateHashReq

SecureBoot.interface = mdb.register_interface('bmc.kepler.Managers.SOC.SecureCore.SecureBoot', {}, {
    ImportCustomCertificateHash = {'a{ss}ay', '', TImportCustomCertificateHashReq, TImportCustomCertificateHashRsp},
    ExportCustomCertificateHash = {'a{ss}i', 'ay', TExportCustomCertificateHashReq, TExportCustomCertificateHashRsp},
    DisableBootVerification = {'a{ss}', '', TDisableBootVerificationReq, TDisableBootVerificationRsp},
    ImportRepairCredentials = {'a{ss}ay', '', TImportRepairCredentialsReq, TImportRepairCredentialsRsp},
    ExportRepairCredentials = {'a{ss}', 'ay', TExportRepairCredentialsReq, TExportRepairCredentialsRsp},
    ResetOnNextBMCReset = {'a{ss}', 'b', TResetOnNextBMCResetReq, TResetOnNextBMCResetRsp}
}, {})

return SecureBoot
