-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerAction = {}

---@class PowerAction.PowerOnTimeoutFlag
---@field PowerOnTimeoutFlag integer
local TPowerOnTimeoutFlag = {}
TPowerOnTimeoutFlag.__index = TPowerOnTimeoutFlag
TPowerOnTimeoutFlag.group = {}

local function TPowerOnTimeoutFlag_from_obj(obj)
    return setmetatable(obj, TPowerOnTimeoutFlag)
end

function TPowerOnTimeoutFlag.new(PowerOnTimeoutFlag)
    return TPowerOnTimeoutFlag_from_obj({PowerOnTimeoutFlag = PowerOnTimeoutFlag})
end
---@param obj PowerAction.PowerOnTimeoutFlag
function TPowerOnTimeoutFlag:init_from_obj(obj)
    self.PowerOnTimeoutFlag = obj.PowerOnTimeoutFlag
end

function TPowerOnTimeoutFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnTimeoutFlag.group)
end

TPowerOnTimeoutFlag.from_obj = TPowerOnTimeoutFlag_from_obj

TPowerOnTimeoutFlag.proto_property = {'PowerOnTimeoutFlag'}

TPowerOnTimeoutFlag.default = {0}

TPowerOnTimeoutFlag.struct = {{name = 'PowerOnTimeoutFlag', is_array = false, struct = nil}}

function TPowerOnTimeoutFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnTimeoutFlag', self.PowerOnTimeoutFlag, 'uint8', false, errs, need_convert)

    TPowerOnTimeoutFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnTimeoutFlag.proto_property, errs, need_convert)
    return self
end

function TPowerOnTimeoutFlag:unpack(_)
    return self.PowerOnTimeoutFlag
end

PowerAction.PowerOnTimeoutFlag = TPowerOnTimeoutFlag

PowerAction.interface = mdb.register_interface('bmc.kepler.Systems.PowerAction',
    {PowerOnTimeoutFlag = {'y', {}, false, nil, false}}, {}, {})

return PowerAction
