-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DelayedPowerOnPolicy = {}

---@class DelayedPowerOnPolicy.Seconds
---@field Seconds number
local TSeconds = {}
TSeconds.__index = TSeconds
TSeconds.group = {}

local function TSeconds_from_obj(obj)
    return setmetatable(obj, TSeconds)
end

function TSeconds.new(Seconds)
    return TSeconds_from_obj({Seconds = Seconds})
end
---@param obj DelayedPowerOnPolicy.Seconds
function TSeconds:init_from_obj(obj)
    self.Seconds = obj.Seconds
end

function TSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSeconds.group)
end

TSeconds.from_obj = TSeconds_from_obj

TSeconds.proto_property = {'Seconds'}

TSeconds.default = {0}

TSeconds.struct = {{name = 'Seconds', is_array = false, struct = nil}}

function TSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Seconds', self.Seconds, 'double', false, errs, need_convert)

    TSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSeconds.proto_property, errs, need_convert)
    return self
end

function TSeconds:unpack(_)
    return self.Seconds
end

DelayedPowerOnPolicy.Seconds = TSeconds

---@class DelayedPowerOnPolicy.Mode
---@field Mode string
local TMode = {}
TMode.__index = TMode
TMode.group = {}

local function TMode_from_obj(obj)
    return setmetatable(obj, TMode)
end

function TMode.new(Mode)
    return TMode_from_obj({Mode = Mode or [=[DefaultDelay]=]})
end
---@param obj DelayedPowerOnPolicy.Mode
function TMode:init_from_obj(obj)
    self.Mode = obj.Mode or [=[DefaultDelay]=]
end

function TMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMode.group)
end

TMode.from_obj = TMode_from_obj

TMode.proto_property = {'Mode'}

TMode.default = {''}

TMode.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'string', false, errs, need_convert)

    TMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMode.proto_property, errs, need_convert)
    return self
end

function TMode:unpack(_)
    return self.Mode
end

DelayedPowerOnPolicy.Mode = TMode

DelayedPowerOnPolicy.interface = mdb.register_interface('bmc.kepler.Systems.DelayedPowerOnPolicy', {
    Mode = {'s', {}, false, 'DefaultDelay', false},
    Seconds = {'d', {}, false, nil, false}
}, {}, {})

return DelayedPowerOnPolicy
