--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'fructrl.ipmi.ipmi_message'

local CT = enums.ChannelType

local fructrl = {}

fructrl.SetPowerCmd = {
    name = 'SetPowerCmd',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x02,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Cmd:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetPowerCmdReq,
    rsp = msg.SetPowerCmdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetACLostStatus = {
    name = 'SetACLostStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x97,
    role = types.Role.User,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,15]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x15:1/unit:8, Status:1/]=] .. [=[unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetACLostStatusReq,
    rsp = msg.SetACLostStatusRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.GetACLostStatus = {
    name = 'GetACLostStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x97,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,16]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x16:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Status:1/unit:8, 0x00:1/unit:8>>]=],
    req = msg.GetACLostStatusReq,
    rsp = msg.GetACLostStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetButtonShieldState = {
    name = 'SetButtonShieldState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5a,0a,00,03,00,*,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5a:1/unit:8, 0x0a:1/un]=] ..
        [=[it:8, 0x00:1/unit:8, 0x0003:2/unit:8, FruId:1/unit]=] .. [=[:8, 0x00:1/unit:8, ShieldState:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetButtonShieldStateReq,
    rsp = msg.SetButtonShieldStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.GetButtonShieldState = {
    name = 'GetButtonShieldState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5b,0a,00,02,00,*,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5b:1/unit:8, 0x0a:1/un]=] ..
        [=[it:8, 0x00:1/unit:8, 0x0002:2/unit:8, FruId:1/unit]=] .. [=[:8, 0x00:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ State:1/unit:8>>]=],
    req = msg.GetButtonShieldStateReq,
    rsp = msg.GetButtonShieldStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetRestorePolicy = {
    name = 'SetRestorePolicy',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x06,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<RestorePolicy:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RestorePolicy:1/unit:8>]=] .. [=[>]=],
    req = msg.SetRestorePolicyReq,
    rsp = msg.SetRestorePolicyRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.SetCycleInterval = {
    name = 'SetCycleInterval',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x0b,
    role = types.Role.Administrator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Seconds:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetCycleIntervalReq,
    rsp = msg.SetCycleIntervalRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.OEMGetRestartCause = {
    name = 'OEMGetRestartCause',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,11]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x11:1/unit:8, FruId:1/u]=] .. [=[nit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ RestartCause:1/unit:8, SrcChan:1/unit:8>>]=],
    req = msg.OEMGetRestartCauseReq,
    rsp = msg.OEMGetRestartCauseRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

fructrl.CMDGetRestartCause = {
    name = 'CMDGetRestartCause',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x07,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, RestartCause:1/unit:8, ]=] .. [=[SrcChan:1/unit:8>>]=],
    req = msg.CMDGetRestartCauseReq,
    rsp = msg.CMDGetRestartCauseRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetPowerLevel = {
    name = 'SetPowerLevel',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x11,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00,00]=],
    decode = [=[<<0x00:1/unit:8, 0x00:1/unit:8, PowerLevel:1/unit:]=] .. [=[8, LevelOption:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, 0x00:1/unit:8>>]=],
    req = msg.SetPowerLevelReq,
    rsp = msg.SetPowerLevelRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.GetPowerLevel = {
    name = 'GetPowerLevel',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x12,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00,00]=],
    decode = [=[<<0x00:1/unit:8, 0x00:1/unit:8, PowerType:1/unit:8]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, 0x00:1/unit:8, PowerSta]=] ..
        [=[te:1/unit:8, DelayToStable:1/unit:8, PowerMultipli]=] .. [=[er:1/unit:8, PowerDraw/string>>]=],
    req = msg.GetPowerLevelReq,
    rsp = msg.GetPowerLevelRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

fructrl.CmdFruCtrl = {
    name = 'CmdFruCtrl',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x04,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId:1/unit:8, Option:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, 0x00:1/unit:8>>]=],
    req = msg.CmdFruCtrlReq,
    rsp = msg.CmdFruCtrlRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetSysLockDownState = {
    name = 'SetSysLockDownState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.SecurityMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,58]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x58:1/unit:8, State:1/u]=] .. [=[nit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetSysLockDownStateReq,
    rsp = msg.SetSysLockDownStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

fructrl.GetSysLockDownState = {
    name = 'GetSysLockDownState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Administrator,
    privilege = privilege.SecurityMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,59]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x59:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ State:1/unit:8>>]=],
    req = msg.GetSysLockDownStateReq,
    rsp = msg.GetSysLockDownStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetFruActivation = {
    name = 'SetFruActivation',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x0c,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId:1/unit:8, Cmd:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, 0x00:1/unit:8>>]=],
    req = msg.SetFruActivationReq,
    rsp = msg.SetFruActivationRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.GetFruActivationPolicy = {
    name = 'GetFruActivationPolicy',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x0b,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, 0x00:1/unit:8, Policy:1]=] .. [=[/unit:8>>]=],
    req = msg.GetFruActivationPolicyReq,
    rsp = msg.GetFruActivationPolicyRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

fructrl.SetFruActivationPolicy = {
    name = 'SetFruActivationPolicy',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x0a,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruId:1/unit:8, Mask:1/unit:8, Bi]=] .. [=[t:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, 0x00:1/unit:8>>]=],
    req = msg.SetFruActivationPolicyReq,
    rsp = msg.SetFruActivationPolicyRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

fructrl.SetACPIPowerState = {
    name = 'SetACPIPowerState',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x06,
    role = types.Role.Administrator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<ACPISystemPowerState:1/unit:8, ACPIDevicePowerSt]=] .. [=[ate:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetACPIPowerStateReq,
    rsp = msg.SetACPIPowerStateRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

fructrl.GetACPIPowerState = {
    name = 'GetACPIPowerState',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x07,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, ACPISystemPowerState:1/]=] .. [=[unit:8, ACPIDevicePowerState:1/unit:8>>]=],
    req = msg.GetACPIPowerStateReq,
    rsp = msg.GetACPIPowerStateRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return fructrl
