--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSysLockDownState = {}

---@class fructrl.SetSysLockDownStateReq
---@field ManufactureId integer
---@field State integer
local TSetSysLockDownStateReq = {}
TSetSysLockDownStateReq.__index = TSetSysLockDownStateReq
TSetSysLockDownStateReq.group = {}

local function TSetSysLockDownStateReq_from_obj(obj)
    return setmetatable(obj, TSetSysLockDownStateReq)
end

function TSetSysLockDownStateReq.new(ManufactureId, State)
    return TSetSysLockDownStateReq_from_obj({ManufactureId = ManufactureId, State = State})
end
---@param obj fructrl.SetSysLockDownStateReq
function TSetSysLockDownStateReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.State = obj.State
end

function TSetSysLockDownStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSysLockDownStateReq.group)
end

TSetSysLockDownStateReq.from_obj = TSetSysLockDownStateReq_from_obj

TSetSysLockDownStateReq.proto_property = {'ManufactureId', 'State'}

TSetSysLockDownStateReq.default = {0, 0}

TSetSysLockDownStateReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'State', is_array = false, struct = nil}
}

function TSetSysLockDownStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TSetSysLockDownStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSysLockDownStateReq.proto_property, errs, need_convert)
    return self
end

function TSetSysLockDownStateReq:unpack(_)
    return self.ManufactureId, self.State
end

SetSysLockDownState.SetSysLockDownStateReq = TSetSysLockDownStateReq

---@class fructrl.SetSysLockDownStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSysLockDownStateRsp = {}
TSetSysLockDownStateRsp.__index = TSetSysLockDownStateRsp
TSetSysLockDownStateRsp.group = {}

local function TSetSysLockDownStateRsp_from_obj(obj)
    return setmetatable(obj, TSetSysLockDownStateRsp)
end

function TSetSysLockDownStateRsp.new(CompletionCode, ManufactureId)
    return TSetSysLockDownStateRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj fructrl.SetSysLockDownStateRsp
function TSetSysLockDownStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSysLockDownStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSysLockDownStateRsp.group)
end

TSetSysLockDownStateRsp.from_obj = TSetSysLockDownStateRsp_from_obj

TSetSysLockDownStateRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSysLockDownStateRsp.default = {0, 0}

TSetSysLockDownStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSysLockDownStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSysLockDownStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSysLockDownStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetSysLockDownStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSysLockDownState.SetSysLockDownStateRsp = TSetSysLockDownStateRsp

return SetSysLockDownState
