--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPowerCmd = {}

---@class fructrl.SetPowerCmdReq
---@field Cmd integer
local TSetPowerCmdReq = {}
TSetPowerCmdReq.__index = TSetPowerCmdReq
TSetPowerCmdReq.group = {}

local function TSetPowerCmdReq_from_obj(obj)
    return setmetatable(obj, TSetPowerCmdReq)
end

function TSetPowerCmdReq.new(Cmd)
    return TSetPowerCmdReq_from_obj({Cmd = Cmd})
end
---@param obj fructrl.SetPowerCmdReq
function TSetPowerCmdReq:init_from_obj(obj)
    self.Cmd = obj.Cmd
end

function TSetPowerCmdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerCmdReq.group)
end

TSetPowerCmdReq.from_obj = TSetPowerCmdReq_from_obj

TSetPowerCmdReq.proto_property = {'Cmd'}

TSetPowerCmdReq.default = {0}

TSetPowerCmdReq.struct = {{name = 'Cmd', is_array = false, struct = nil}}

function TSetPowerCmdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cmd', self.Cmd, 'uint8', false, errs, need_convert)

    TSetPowerCmdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerCmdReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerCmdReq:unpack(_)
    return self.Cmd
end

SetPowerCmd.SetPowerCmdReq = TSetPowerCmdReq

---@class fructrl.SetPowerCmdRsp
---@field CompletionCode integer
local TSetPowerCmdRsp = {}
TSetPowerCmdRsp.__index = TSetPowerCmdRsp
TSetPowerCmdRsp.group = {}

local function TSetPowerCmdRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerCmdRsp)
end

function TSetPowerCmdRsp.new(CompletionCode)
    return TSetPowerCmdRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetPowerCmdRsp
function TSetPowerCmdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPowerCmdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerCmdRsp.group)
end

TSetPowerCmdRsp.from_obj = TSetPowerCmdRsp_from_obj

TSetPowerCmdRsp.proto_property = {'CompletionCode'}

TSetPowerCmdRsp.default = {0}

TSetPowerCmdRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPowerCmdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPowerCmdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerCmdRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerCmdRsp:unpack(_)
    return self.CompletionCode
end

SetPowerCmd.SetPowerCmdRsp = TSetPowerCmdRsp

return SetPowerCmd
