--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetButtonShieldState = {}

---@class fructrl.SetButtonShieldStateReq
---@field ManufactureId integer
---@field FruId integer
---@field ShieldState integer
local TSetButtonShieldStateReq = {}
TSetButtonShieldStateReq.__index = TSetButtonShieldStateReq
TSetButtonShieldStateReq.group = {}

local function TSetButtonShieldStateReq_from_obj(obj)
    return setmetatable(obj, TSetButtonShieldStateReq)
end

function TSetButtonShieldStateReq.new(ManufactureId, FruId, ShieldState)
    return TSetButtonShieldStateReq_from_obj({ManufactureId = ManufactureId, FruId = FruId, ShieldState = ShieldState})
end
---@param obj fructrl.SetButtonShieldStateReq
function TSetButtonShieldStateReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.FruId = obj.FruId
    self.ShieldState = obj.ShieldState
end

function TSetButtonShieldStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetButtonShieldStateReq.group)
end

TSetButtonShieldStateReq.from_obj = TSetButtonShieldStateReq_from_obj

TSetButtonShieldStateReq.proto_property = {'ManufactureId', 'FruId', 'ShieldState'}

TSetButtonShieldStateReq.default = {0, 0, 0}

TSetButtonShieldStateReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil},
    {name = 'ShieldState', is_array = false, struct = nil}
}

function TSetButtonShieldStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ShieldState', self.ShieldState, 'uint8', false, errs, need_convert)

    TSetButtonShieldStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetButtonShieldStateReq.proto_property, errs, need_convert)
    return self
end

function TSetButtonShieldStateReq:unpack(_)
    return self.ManufactureId, self.FruId, self.ShieldState
end

SetButtonShieldState.SetButtonShieldStateReq = TSetButtonShieldStateReq

---@class fructrl.SetButtonShieldStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetButtonShieldStateRsp = {}
TSetButtonShieldStateRsp.__index = TSetButtonShieldStateRsp
TSetButtonShieldStateRsp.group = {}

local function TSetButtonShieldStateRsp_from_obj(obj)
    return setmetatable(obj, TSetButtonShieldStateRsp)
end

function TSetButtonShieldStateRsp.new(CompletionCode, ManufactureId)
    return TSetButtonShieldStateRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj fructrl.SetButtonShieldStateRsp
function TSetButtonShieldStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetButtonShieldStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetButtonShieldStateRsp.group)
end

TSetButtonShieldStateRsp.from_obj = TSetButtonShieldStateRsp_from_obj

TSetButtonShieldStateRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetButtonShieldStateRsp.default = {0, 0}

TSetButtonShieldStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetButtonShieldStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetButtonShieldStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetButtonShieldStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetButtonShieldStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetButtonShieldState.SetButtonShieldStateRsp = TSetButtonShieldStateRsp

return SetButtonShieldState
