--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetACPIPowerState = {}

---@class fructrl.SetACPIPowerStateReq
---@field ACPISystemPowerState integer
---@field ACPIDevicePowerState integer
local TSetACPIPowerStateReq = {}
TSetACPIPowerStateReq.__index = TSetACPIPowerStateReq
TSetACPIPowerStateReq.group = {}

local function TSetACPIPowerStateReq_from_obj(obj)
    return setmetatable(obj, TSetACPIPowerStateReq)
end

function TSetACPIPowerStateReq.new(ACPISystemPowerState, ACPIDevicePowerState)
    return TSetACPIPowerStateReq_from_obj({
        ACPISystemPowerState = ACPISystemPowerState,
        ACPIDevicePowerState = ACPIDevicePowerState
    })
end
---@param obj fructrl.SetACPIPowerStateReq
function TSetACPIPowerStateReq:init_from_obj(obj)
    self.ACPISystemPowerState = obj.ACPISystemPowerState
    self.ACPIDevicePowerState = obj.ACPIDevicePowerState
end

function TSetACPIPowerStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACPIPowerStateReq.group)
end

TSetACPIPowerStateReq.from_obj = TSetACPIPowerStateReq_from_obj

TSetACPIPowerStateReq.proto_property = {'ACPISystemPowerState', 'ACPIDevicePowerState'}

TSetACPIPowerStateReq.default = {0, 0}

TSetACPIPowerStateReq.struct = {
    {name = 'ACPISystemPowerState', is_array = false, struct = nil},
    {name = 'ACPIDevicePowerState', is_array = false, struct = nil}
}

function TSetACPIPowerStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ACPISystemPowerState', self.ACPISystemPowerState, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ACPIDevicePowerState', self.ACPIDevicePowerState, 'uint8', false, errs, need_convert)

    TSetACPIPowerStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACPIPowerStateReq.proto_property, errs, need_convert)
    return self
end

function TSetACPIPowerStateReq:unpack(_)
    return self.ACPISystemPowerState, self.ACPIDevicePowerState
end

SetACPIPowerState.SetACPIPowerStateReq = TSetACPIPowerStateReq

---@class fructrl.SetACPIPowerStateRsp
---@field CompletionCode integer
local TSetACPIPowerStateRsp = {}
TSetACPIPowerStateRsp.__index = TSetACPIPowerStateRsp
TSetACPIPowerStateRsp.group = {}

local function TSetACPIPowerStateRsp_from_obj(obj)
    return setmetatable(obj, TSetACPIPowerStateRsp)
end

function TSetACPIPowerStateRsp.new(CompletionCode)
    return TSetACPIPowerStateRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetACPIPowerStateRsp
function TSetACPIPowerStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetACPIPowerStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACPIPowerStateRsp.group)
end

TSetACPIPowerStateRsp.from_obj = TSetACPIPowerStateRsp_from_obj

TSetACPIPowerStateRsp.proto_property = {'CompletionCode'}

TSetACPIPowerStateRsp.default = {0}

TSetACPIPowerStateRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetACPIPowerStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetACPIPowerStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACPIPowerStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetACPIPowerStateRsp:unpack(_)
    return self.CompletionCode
end

SetACPIPowerState.SetACPIPowerStateRsp = TSetACPIPowerStateRsp

return SetACPIPowerState
