--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetACLostStatus = {}

---@class fructrl.SetACLostStatusReq
---@field ManufactureId integer
---@field Status integer
local TSetACLostStatusReq = {}
TSetACLostStatusReq.__index = TSetACLostStatusReq
TSetACLostStatusReq.group = {}

local function TSetACLostStatusReq_from_obj(obj)
    return setmetatable(obj, TSetACLostStatusReq)
end

function TSetACLostStatusReq.new(ManufactureId, Status)
    return TSetACLostStatusReq_from_obj({ManufactureId = ManufactureId, Status = Status})
end
---@param obj fructrl.SetACLostStatusReq
function TSetACLostStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Status = obj.Status
end

function TSetACLostStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACLostStatusReq.group)
end

TSetACLostStatusReq.from_obj = TSetACLostStatusReq_from_obj

TSetACLostStatusReq.proto_property = {'ManufactureId', 'Status'}

TSetACLostStatusReq.default = {0, 0}

TSetACLostStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TSetACLostStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetACLostStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACLostStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetACLostStatusReq:unpack(_)
    return self.ManufactureId, self.Status
end

SetACLostStatus.SetACLostStatusReq = TSetACLostStatusReq

---@class fructrl.SetACLostStatusRsp
---@field CompletionCode integer
local TSetACLostStatusRsp = {}
TSetACLostStatusRsp.__index = TSetACLostStatusRsp
TSetACLostStatusRsp.group = {}

local function TSetACLostStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetACLostStatusRsp)
end

function TSetACLostStatusRsp.new(CompletionCode)
    return TSetACLostStatusRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetACLostStatusRsp
function TSetACLostStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetACLostStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACLostStatusRsp.group)
end

TSetACLostStatusRsp.from_obj = TSetACLostStatusRsp_from_obj

TSetACLostStatusRsp.proto_property = {'CompletionCode'}

TSetACLostStatusRsp.default = {0}

TSetACLostStatusRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetACLostStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetACLostStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACLostStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetACLostStatusRsp:unpack(_)
    return self.CompletionCode
end

SetACLostStatus.SetACLostStatusRsp = TSetACLostStatusRsp

return SetACLostStatus
