--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSysLockDownState = {}

---@class fructrl.GetSysLockDownStateReq
---@field ManufactureId integer
local TGetSysLockDownStateReq = {}
TGetSysLockDownStateReq.__index = TGetSysLockDownStateReq
TGetSysLockDownStateReq.group = {}

local function TGetSysLockDownStateReq_from_obj(obj)
    return setmetatable(obj, TGetSysLockDownStateReq)
end

function TGetSysLockDownStateReq.new(ManufactureId)
    return TGetSysLockDownStateReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj fructrl.GetSysLockDownStateReq
function TGetSysLockDownStateReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetSysLockDownStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSysLockDownStateReq.group)
end

TGetSysLockDownStateReq.from_obj = TGetSysLockDownStateReq_from_obj

TGetSysLockDownStateReq.proto_property = {'ManufactureId'}

TGetSysLockDownStateReq.default = {0}

TGetSysLockDownStateReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetSysLockDownStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetSysLockDownStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSysLockDownStateReq.proto_property, errs, need_convert)
    return self
end

function TGetSysLockDownStateReq:unpack(_)
    return self.ManufactureId
end

GetSysLockDownState.GetSysLockDownStateReq = TGetSysLockDownStateReq

---@class fructrl.GetSysLockDownStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field State integer
local TGetSysLockDownStateRsp = {}
TGetSysLockDownStateRsp.__index = TGetSysLockDownStateRsp
TGetSysLockDownStateRsp.group = {}

local function TGetSysLockDownStateRsp_from_obj(obj)
    return setmetatable(obj, TGetSysLockDownStateRsp)
end

function TGetSysLockDownStateRsp.new(CompletionCode, ManufactureId, State)
    return TGetSysLockDownStateRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        State = State
    })
end
---@param obj fructrl.GetSysLockDownStateRsp
function TGetSysLockDownStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.State = obj.State
end

function TGetSysLockDownStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSysLockDownStateRsp.group)
end

TGetSysLockDownStateRsp.from_obj = TGetSysLockDownStateRsp_from_obj

TGetSysLockDownStateRsp.proto_property = {'CompletionCode', 'ManufactureId', 'State'}

TGetSysLockDownStateRsp.default = {0, 0, 0}

TGetSysLockDownStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TGetSysLockDownStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TGetSysLockDownStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSysLockDownStateRsp.proto_property, errs, need_convert)
    return self
end

function TGetSysLockDownStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.State
end

GetSysLockDownState.GetSysLockDownStateRsp = TGetSysLockDownStateRsp

return GetSysLockDownState
