-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MThermTrip = {}

---@class MThermTrip.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MThermTrip.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MThermTrip.IsValid = TIsValid

---@class MThermTrip.TimeDelaySeconds
---@field TimeDelaySeconds integer
local TTimeDelaySeconds = {}
TTimeDelaySeconds.__index = TTimeDelaySeconds
TTimeDelaySeconds.group = {}

local function TTimeDelaySeconds_from_obj(obj)
    return setmetatable(obj, TTimeDelaySeconds)
end

function TTimeDelaySeconds.new(TimeDelaySeconds)
    return TTimeDelaySeconds_from_obj({TimeDelaySeconds = TimeDelaySeconds or 300})
end
---@param obj MThermTrip.TimeDelaySeconds
function TTimeDelaySeconds:init_from_obj(obj)
    self.TimeDelaySeconds = obj.TimeDelaySeconds or 300
end

function TTimeDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeDelaySeconds.group)
end

TTimeDelaySeconds.from_obj = TTimeDelaySeconds_from_obj

TTimeDelaySeconds.proto_property = {'TimeDelaySeconds'}

TTimeDelaySeconds.default = {0}

TTimeDelaySeconds.struct = {{name = 'TimeDelaySeconds', is_array = false, struct = nil}}

function TTimeDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeDelaySeconds', self.TimeDelaySeconds, 'uint32', false, errs, need_convert)

    TTimeDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TTimeDelaySeconds:unpack(_)
    return self.TimeDelaySeconds
end

MThermTrip.TimeDelaySeconds = TTimeDelaySeconds

---@class MThermTrip.Actions
---@field Actions integer
local TActions = {}
TActions.__index = TActions
TActions.group = {}

local function TActions_from_obj(obj)
    return setmetatable(obj, TActions)
end

function TActions.new(Actions)
    return TActions_from_obj({Actions = Actions or 1})
end
---@param obj MThermTrip.Actions
function TActions:init_from_obj(obj)
    self.Actions = obj.Actions or 1
end

function TActions:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActions.group)
end

TActions.from_obj = TActions_from_obj

TActions.proto_property = {'Actions'}

TActions.default = {0}

TActions.struct = {{name = 'Actions', is_array = false, struct = nil}}

function TActions:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Actions', self.Actions, 'uint8', true, errs, need_convert)

    TActions:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActions.proto_property, errs, need_convert)
    return self
end

function TActions:unpack(_)
    return self.Actions
end

MThermTrip.Actions = TActions

---@class MThermTrip.SetThermTrip2
---@field SetThermTrip2 integer
local TSetThermTrip2 = {}
TSetThermTrip2.__index = TSetThermTrip2
TSetThermTrip2.group = {}

local function TSetThermTrip2_from_obj(obj)
    return setmetatable(obj, TSetThermTrip2)
end

function TSetThermTrip2.new(SetThermTrip2)
    return TSetThermTrip2_from_obj({SetThermTrip2 = SetThermTrip2})
end
---@param obj MThermTrip.SetThermTrip2
function TSetThermTrip2:init_from_obj(obj)
    self.SetThermTrip2 = obj.SetThermTrip2
end

function TSetThermTrip2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetThermTrip2.group)
end

TSetThermTrip2.from_obj = TSetThermTrip2_from_obj

TSetThermTrip2.proto_property = {'SetThermTrip2'}

TSetThermTrip2.default = {0}

TSetThermTrip2.struct = {{name = 'SetThermTrip2', is_array = false, struct = nil}}

function TSetThermTrip2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetThermTrip2', self.SetThermTrip2, 'uint8', false, errs, need_convert)

    TSetThermTrip2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetThermTrip2.proto_property, errs, need_convert)
    return self
end

function TSetThermTrip2:unpack(_)
    return self.SetThermTrip2
end

MThermTrip.SetThermTrip2 = TSetThermTrip2

---@class MThermTrip.GetThermTrip2
---@field GetThermTrip2 integer
local TGetThermTrip2 = {}
TGetThermTrip2.__index = TGetThermTrip2
TGetThermTrip2.group = {}

local function TGetThermTrip2_from_obj(obj)
    return setmetatable(obj, TGetThermTrip2)
end

function TGetThermTrip2.new(GetThermTrip2)
    return TGetThermTrip2_from_obj({GetThermTrip2 = GetThermTrip2})
end
---@param obj MThermTrip.GetThermTrip2
function TGetThermTrip2:init_from_obj(obj)
    self.GetThermTrip2 = obj.GetThermTrip2
end

function TGetThermTrip2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThermTrip2.group)
end

TGetThermTrip2.from_obj = TGetThermTrip2_from_obj

TGetThermTrip2.proto_property = {'GetThermTrip2'}

TGetThermTrip2.default = {0}

TGetThermTrip2.struct = {{name = 'GetThermTrip2', is_array = false, struct = nil}}

function TGetThermTrip2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetThermTrip2', self.GetThermTrip2, 'uint8', false, errs, need_convert)

    TGetThermTrip2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThermTrip2.proto_property, errs, need_convert)
    return self
end

function TGetThermTrip2:unpack(_)
    return self.GetThermTrip2
end

MThermTrip.GetThermTrip2 = TGetThermTrip2

---@class MThermTrip.SetThermTrip
---@field SetThermTrip integer
local TSetThermTrip = {}
TSetThermTrip.__index = TSetThermTrip
TSetThermTrip.group = {}

local function TSetThermTrip_from_obj(obj)
    return setmetatable(obj, TSetThermTrip)
end

function TSetThermTrip.new(SetThermTrip)
    return TSetThermTrip_from_obj({SetThermTrip = SetThermTrip})
end
---@param obj MThermTrip.SetThermTrip
function TSetThermTrip:init_from_obj(obj)
    self.SetThermTrip = obj.SetThermTrip
end

function TSetThermTrip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetThermTrip.group)
end

TSetThermTrip.from_obj = TSetThermTrip_from_obj

TSetThermTrip.proto_property = {'SetThermTrip'}

TSetThermTrip.default = {0}

TSetThermTrip.struct = {{name = 'SetThermTrip', is_array = false, struct = nil}}

function TSetThermTrip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetThermTrip', self.SetThermTrip, 'uint8', false, errs, need_convert)

    TSetThermTrip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetThermTrip.proto_property, errs, need_convert)
    return self
end

function TSetThermTrip:unpack(_)
    return self.SetThermTrip
end

MThermTrip.SetThermTrip = TSetThermTrip

---@class MThermTrip.GetThermTrip
---@field GetThermTrip integer
local TGetThermTrip = {}
TGetThermTrip.__index = TGetThermTrip
TGetThermTrip.group = {}

local function TGetThermTrip_from_obj(obj)
    return setmetatable(obj, TGetThermTrip)
end

function TGetThermTrip.new(GetThermTrip)
    return TGetThermTrip_from_obj({GetThermTrip = GetThermTrip})
end
---@param obj MThermTrip.GetThermTrip
function TGetThermTrip:init_from_obj(obj)
    self.GetThermTrip = obj.GetThermTrip
end

function TGetThermTrip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThermTrip.group)
end

TGetThermTrip.from_obj = TGetThermTrip_from_obj

TGetThermTrip.proto_property = {'GetThermTrip'}

TGetThermTrip.default = {0}

TGetThermTrip.struct = {{name = 'GetThermTrip', is_array = false, struct = nil}}

function TGetThermTrip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetThermTrip', self.GetThermTrip, 'uint8', false, errs, need_convert)

    TGetThermTrip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThermTrip.proto_property, errs, need_convert)
    return self
end

function TGetThermTrip:unpack(_)
    return self.GetThermTrip
end

MThermTrip.GetThermTrip = TGetThermTrip

---@class MThermTrip.FruID
---@field FruID integer
local TFruID = {}
TFruID.__index = TFruID
TFruID.group = {}

local function TFruID_from_obj(obj)
    return setmetatable(obj, TFruID)
end

function TFruID.new(FruID)
    return TFruID_from_obj({FruID = FruID or 0})
end
---@param obj MThermTrip.FruID
function TFruID:init_from_obj(obj)
    self.FruID = obj.FruID or 0
end

function TFruID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruID.group)
end

TFruID.from_obj = TFruID_from_obj

TFruID.proto_property = {'FruID'}

TFruID.default = {0}

TFruID.struct = {{name = 'FruID', is_array = false, struct = nil}}

function TFruID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruID.proto_property, errs, need_convert)
    return self
end

function TFruID:unpack(_)
    return self.FruID
end

MThermTrip.FruID = TFruID

return MThermTrip
