-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MButtonEvt = {}

---@class MButtonEvt.PowerButtonShieldEnabled
---@field PowerButtonShieldEnabled boolean
local TPowerButtonShieldEnabled = {}
TPowerButtonShieldEnabled.__index = TPowerButtonShieldEnabled
TPowerButtonShieldEnabled.group = {}

local function TPowerButtonShieldEnabled_from_obj(obj)
    return setmetatable(obj, TPowerButtonShieldEnabled)
end

function TPowerButtonShieldEnabled.new(PowerButtonShieldEnabled)
    return TPowerButtonShieldEnabled_from_obj({PowerButtonShieldEnabled = PowerButtonShieldEnabled or false})
end
---@param obj MButtonEvt.PowerButtonShieldEnabled
function TPowerButtonShieldEnabled:init_from_obj(obj)
    self.PowerButtonShieldEnabled = obj.PowerButtonShieldEnabled or false
end

function TPowerButtonShieldEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerButtonShieldEnabled.group)
end

TPowerButtonShieldEnabled.from_obj = TPowerButtonShieldEnabled_from_obj

TPowerButtonShieldEnabled.proto_property = {'PowerButtonShieldEnabled'}

TPowerButtonShieldEnabled.default = {false}

TPowerButtonShieldEnabled.struct = {{name = 'PowerButtonShieldEnabled', is_array = false, struct = nil}}

function TPowerButtonShieldEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerButtonShieldEnabled', self.PowerButtonShieldEnabled, 'bool', false, errs,
        need_convert)

    TPowerButtonShieldEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerButtonShieldEnabled.proto_property, errs, need_convert)
    return self
end

function TPowerButtonShieldEnabled:unpack(_)
    return self.PowerButtonShieldEnabled
end

MButtonEvt.PowerButtonShieldEnabled = TPowerButtonShieldEnabled

---@class MButtonEvt.PowerBtnShield
---@field PowerBtnShield integer
local TPowerBtnShield = {}
TPowerBtnShield.__index = TPowerBtnShield
TPowerBtnShield.group = {}

local function TPowerBtnShield_from_obj(obj)
    return setmetatable(obj, TPowerBtnShield)
end

function TPowerBtnShield.new(PowerBtnShield)
    return TPowerBtnShield_from_obj({PowerBtnShield = PowerBtnShield})
end
---@param obj MButtonEvt.PowerBtnShield
function TPowerBtnShield:init_from_obj(obj)
    self.PowerBtnShield = obj.PowerBtnShield
end

function TPowerBtnShield:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerBtnShield.group)
end

TPowerBtnShield.from_obj = TPowerBtnShield_from_obj

TPowerBtnShield.proto_property = {'PowerBtnShield'}

TPowerBtnShield.default = {0}

TPowerBtnShield.struct = {{name = 'PowerBtnShield', is_array = false, struct = nil}}

function TPowerBtnShield:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerBtnShield', self.PowerBtnShield, 'uint8', false, errs, need_convert)

    TPowerBtnShield:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerBtnShield.proto_property, errs, need_convert)
    return self
end

function TPowerBtnShield:unpack(_)
    return self.PowerBtnShield
end

MButtonEvt.PowerBtnShield = TPowerBtnShield

---@class MButtonEvt.SetPowerBtnEvt
---@field SetPowerBtnEvt integer
local TSetPowerBtnEvt = {}
TSetPowerBtnEvt.__index = TSetPowerBtnEvt
TSetPowerBtnEvt.group = {}

local function TSetPowerBtnEvt_from_obj(obj)
    return setmetatable(obj, TSetPowerBtnEvt)
end

function TSetPowerBtnEvt.new(SetPowerBtnEvt)
    return TSetPowerBtnEvt_from_obj({SetPowerBtnEvt = SetPowerBtnEvt})
end
---@param obj MButtonEvt.SetPowerBtnEvt
function TSetPowerBtnEvt:init_from_obj(obj)
    self.SetPowerBtnEvt = obj.SetPowerBtnEvt
end

function TSetPowerBtnEvt:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerBtnEvt.group)
end

TSetPowerBtnEvt.from_obj = TSetPowerBtnEvt_from_obj

TSetPowerBtnEvt.proto_property = {'SetPowerBtnEvt'}

TSetPowerBtnEvt.default = {0}

TSetPowerBtnEvt.struct = {{name = 'SetPowerBtnEvt', is_array = false, struct = nil}}

function TSetPowerBtnEvt:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetPowerBtnEvt', self.SetPowerBtnEvt, 'uint8', false, errs, need_convert)

    TSetPowerBtnEvt:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerBtnEvt.proto_property, errs, need_convert)
    return self
end

function TSetPowerBtnEvt:unpack(_)
    return self.SetPowerBtnEvt
end

MButtonEvt.SetPowerBtnEvt = TSetPowerBtnEvt

---@class MButtonEvt.GetPowerBtnEvt
---@field GetPowerBtnEvt integer
local TGetPowerBtnEvt = {}
TGetPowerBtnEvt.__index = TGetPowerBtnEvt
TGetPowerBtnEvt.group = {}

local function TGetPowerBtnEvt_from_obj(obj)
    return setmetatable(obj, TGetPowerBtnEvt)
end

function TGetPowerBtnEvt.new(GetPowerBtnEvt)
    return TGetPowerBtnEvt_from_obj({GetPowerBtnEvt = GetPowerBtnEvt})
end
---@param obj MButtonEvt.GetPowerBtnEvt
function TGetPowerBtnEvt:init_from_obj(obj)
    self.GetPowerBtnEvt = obj.GetPowerBtnEvt
end

function TGetPowerBtnEvt:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPowerBtnEvt.group)
end

TGetPowerBtnEvt.from_obj = TGetPowerBtnEvt_from_obj

TGetPowerBtnEvt.proto_property = {'GetPowerBtnEvt'}

TGetPowerBtnEvt.default = {0}

TGetPowerBtnEvt.struct = {{name = 'GetPowerBtnEvt', is_array = false, struct = nil}}

function TGetPowerBtnEvt:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetPowerBtnEvt', self.GetPowerBtnEvt, 'uint8', false, errs, need_convert)

    TGetPowerBtnEvt:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPowerBtnEvt.proto_property, errs, need_convert)
    return self
end

function TGetPowerBtnEvt:unpack(_)
    return self.GetPowerBtnEvt
end

MButtonEvt.GetPowerBtnEvt = TGetPowerBtnEvt

---@class MButtonEvt.PowerBtnLock
---@field PowerBtnLock integer
local TPowerBtnLock = {}
TPowerBtnLock.__index = TPowerBtnLock
TPowerBtnLock.group = {}

local function TPowerBtnLock_from_obj(obj)
    return setmetatable(obj, TPowerBtnLock)
end

function TPowerBtnLock.new(PowerBtnLock)
    return TPowerBtnLock_from_obj({PowerBtnLock = PowerBtnLock})
end
---@param obj MButtonEvt.PowerBtnLock
function TPowerBtnLock:init_from_obj(obj)
    self.PowerBtnLock = obj.PowerBtnLock
end

function TPowerBtnLock:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerBtnLock.group)
end

TPowerBtnLock.from_obj = TPowerBtnLock_from_obj

TPowerBtnLock.proto_property = {'PowerBtnLock'}

TPowerBtnLock.default = {0}

TPowerBtnLock.struct = {{name = 'PowerBtnLock', is_array = false, struct = nil}}

function TPowerBtnLock:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerBtnLock', self.PowerBtnLock, 'uint8', false, errs, need_convert)

    TPowerBtnLock:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerBtnLock.proto_property, errs, need_convert)
    return self
end

function TPowerBtnLock:unpack(_)
    return self.PowerBtnLock
end

MButtonEvt.PowerBtnLock = TPowerBtnLock

---@class MButtonEvt.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MButtonEvt.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MButtonEvt.Id = TId

return MButtonEvt
