-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local chassis_fru_ctrl_class_types = require 'class.types.ChassisFruCtrl'
local fru_ctrl_class_types = require 'class.types.FruCtrl'
local record_fault_class_types = require 'class.types.RecordFault'
local pg_signal_class_types = require 'class.types.PGSignal'
local power_button_class_types = require 'class.types.PowerButton'
local ac_cycle_class_types = require 'class.types.ACCycle'
local nmi_class_types = require 'class.types.Nmi'
local force_reset_class_types = require 'class.types.ForceReset'
local button_evt_class_types = require 'class.types.ButtonEvt'
local sys_reset_class_types = require 'class.types.SysReset'
local therm_trip_class_types = require 'class.types.ThermTrip'
local system_lock_down_class_types = require 'class.types.SystemLockDown'
local power_action_class_types = require 'class.types.PowerAction'
local chassis_fru_ctrl_intf_types = require 'fructrl.json_types.ChassisFruCtrl'
local chassis_power_on_lock_intf_types = require 'fructrl.json_types.ChassisPowerOnLock'
local properties_intf_types = require 'fructrl.json_types.Properties'
local systems_power_on_lock_intf_types = require 'fructrl.json_types.SystemsPowerOnLock'
local delayed_power_on_policy_intf_types = require 'fructrl.json_types.DelayedPowerOnPolicy'
local systems_fru_ctrl_intf_types = require 'fructrl.json_types.SystemsFruCtrl'
local thermal_trip_intf_types = require 'fructrl.json_types.ThermalTrip'
local manufacture_intf_types = require 'fructrl.json_types.Manufacture'
local system_lock_down_intf_types = require 'fructrl.json_types.SystemLockDown'
local power_action_intf_types = require 'fructrl.json_types.PowerAction'
local multihost_intf_types = require 'fructrl.json_types.Multihost'
local fru_ctrl_capabilities_intf_types = require 'fructrl.json_types.FruCtrlCapabilities'

local ChassisFruCtrl = {
    ['table_name'] = 't_chassis_fructrl_tb',
    ['prop_configs'] = {
        ['Id'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = chassis_fru_ctrl_class_types.Id},
        ['PowerGDState'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_fru_ctrl_class_types.PowerGDState
        },
        ['StaggeredPowerOnInterval'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 60,
            ['validator'] = chassis_fru_ctrl_class_types.StaggeredPowerOnInterval
        },
        ['PowerCycleInterval'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 10,
            ['validator'] = chassis_fru_ctrl_class_types.PowerCycleInterval
        },
        ['PowerCycleType'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_fru_ctrl_class_types.PowerCycleType
        },
        ['PowerCycleState'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_fru_ctrl_class_types.PowerCycleState
        }
    },
    ['default_props'] = {
        ['Id'] = chassis_fru_ctrl_class_types.Id.default[1],
        ['PowerGDState'] = chassis_fru_ctrl_class_types.PowerGDState.default[1],
        ['StaggeredPowerOnInterval'] = 60,
        ['PowerCycleInterval'] = 10,
        ['PowerCycleType'] = 0,
        ['PowerCycleState'] = 0
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.FruCtrl'] = {
            ['PowerState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'ON', 'OFF'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = chassis_fru_ctrl_intf_types.PowerState
            },
            ['PowerOnStrategy'] = {
                ['baseType'] = 'String',
                ['enum'] = {'AlwaysPowerOff', 'AlwaysPowerOn', 'LastState', 'AlwaysPowerOnUnmodifiable'},
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['default'] = 'AlwaysPowerOn',
                ['validator'] = chassis_fru_ctrl_intf_types.PowerOnStrategy
            },
            ['PreviousPowerState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'ON', 'OFF'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['default'] = 'ON',
                ['validator'] = chassis_fru_ctrl_intf_types.PreviousPowerState
            }
        },
        ['bmc.kepler.Chassis.PowerOnLock'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.FruCtrl'] = {
            ['PowerCtrl'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {
                            'On', 'ForceOff', 'GracefulShutdown', 'ForceRestart', 'Nmi', 'PowerCycle',
                            'ForcePowerCycle', 'ACCycle'
                        },
                        ['param'] = 'OperateType'
                    }, {
                        ['baseType'] = 'String',
                        ['enum'] = {
                            'Unknown', 'ChassisControlCommand', 'ResetViaPushButton', 'PowerUpViaPushButton',
                            'WatchdogExpiration', 'Oem', 'ACRestoreAlwaysPowerUp', 'ACRestoreKeepPreviousState',
                            'ResetViaPEF', 'PowerCycleViaPEF', 'SoftReset', 'PowerupViaRTC'
                        },
                        ['param'] = 'RestartCause'
                    }
                },
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetPowerOnStrategyExceptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'Reason'}, {['baseType'] = 'String', ['param'] = 'Execute'},
                    {['baseType'] = 'String', ['param'] = 'EffectivePeriod'},
                    {['baseType'] = 'U8', ['param'] = 'Priority'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Chassis.PowerOnLock'] = {
            ['SetPowerOnLock'] = {
                ['req'] = {
                    {['baseType'] = 'Boolean', ['param'] = 'PwrOnLocked'},
                    {['baseType'] = 'U32', ['param'] = 'Timeout'}, {['baseType'] = 'String', ['param'] = 'AppName'},
                    {['baseType'] = 'String', ['param'] = 'Reason'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/FruCtrl'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.FruCtrl'] = {
            ['property_defaults'] = {
                ['PowerState'] = chassis_fru_ctrl_intf_types.PowerState.default[1],
                ['PowerOnStrategy'] = 'AlwaysPowerOn',
                ['PreviousPowerState'] = 'ON'
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['PowerOnStrategy'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt}},
                ['methods'] = {
                    ['PowerCtrl'] = privilege.PowerMgmt,
                    ['SetPowerOnStrategyExceptions'] = privilege.PowerMgmt
                }
            },
            ['interface_types'] = chassis_fru_ctrl_intf_types
        },
        ['bmc.kepler.Chassis.PowerOnLock'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPowerOnLock'] = privilege.PowerMgmt}},
            ['interface_types'] = chassis_power_on_lock_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local FruCtrl = {
    ['table_name'] = 't_fructrl_tb',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = fru_ctrl_class_types.Id
        },
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = fru_ctrl_class_types.FruID
        },
        ['PwrCycleDelaySeconds'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U32',
            ['default'] = 10,
            ['validator'] = fru_ctrl_class_types.PwrCycleDelaySeconds
        },
        ['PwrStateBeforeACLost'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'Boolean',
            ['validator'] = fru_ctrl_class_types.PwrStateBeforeACLost
        },
        ['BmcResetFlag'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = fru_ctrl_class_types.BmcResetFlag
        },
        ['PwrRestoreRecord'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'String[]',
            ['validator'] = fru_ctrl_class_types.PwrRestoreRecord
        },
        ['PwrOnLockedRecord'] = {
            ['usage'] = {'TemporaryPer'},
            ['baseType'] = 'Dictionary',
            ['$ref'] = 'types.json#/defs/PwrOnLockedRecord',
            ['validator'] = fru_ctrl_class_types.PwrOnLockedRecord
        },
        ['PowerOnTimeoutSeconds'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 10,
            ['validator'] = fru_ctrl_class_types.PowerOnTimeoutSeconds
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = fru_ctrl_class_types.IsValid
        },
        ['ACPISystemPowerState'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = fru_ctrl_class_types.ACPISystemPowerState
        },
        ['ACPIDevicePowerState'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = fru_ctrl_class_types.ACPIDevicePowerState
        },
        ['ActionModified'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = fru_ctrl_class_types.ActionModified
        },
        ['TimeDelaySecondsModified'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = fru_ctrl_class_types.TimeDelaySecondsModified
        }
    },
    ['default_props'] = {
        ['Id'] = fru_ctrl_class_types.Id.default[1],
        ['FruID'] = 0,
        ['PwrCycleDelaySeconds'] = 10,
        ['PwrStateBeforeACLost'] = fru_ctrl_class_types.PwrStateBeforeACLost.default[1],
        ['BmcResetFlag'] = 0,
        ['PwrRestoreRecord'] = fru_ctrl_class_types.PwrRestoreRecord.default[1],
        ['PwrOnLockedRecord'] = fru_ctrl_class_types.PwrOnLockedRecord.default[1],
        ['PowerOnTimeoutSeconds'] = 10,
        ['IsValid'] = true,
        ['ACPISystemPowerState'] = '',
        ['ACPIDevicePowerState'] = '',
        ['ActionModified'] = false,
        ['TimeDelaySecondsModified'] = false
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerOnLock'] = {
            ['PwrOnLocked'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'TemporaryPer'},
                ['validator'] = systems_power_on_lock_intf_types.PwrOnLocked
            },
            ['Reasons'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'TemporaryPer'},
                ['validator'] = systems_power_on_lock_intf_types.Reasons
            }
        },
        ['bmc.kepler.Systems.DelayedPowerOnPolicy'] = {
            ['Mode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['default'] = 'DefaultDelay',
                ['validator'] = delayed_power_on_policy_intf_types.Mode
            },
            ['Seconds'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = delayed_power_on_policy_intf_types.Seconds
            }
        },
        ['bmc.kepler.Systems.FruCtrl'] = {
            ['PowerState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = systems_fru_ctrl_intf_types.PowerState
            },
            ['SysResetDetected'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_fru_ctrl_intf_types.SysResetDetected
            },
            ['FruType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_fru_ctrl_intf_types.FruType
            },
            ['CurrentRestartCause'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = systems_fru_ctrl_intf_types.CurrentRestartCause
            },
            ['CurrentRestartCauseId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = systems_fru_ctrl_intf_types.CurrentRestartCauseId
            },
            ['CurrentRestartType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = systems_fru_ctrl_intf_types.CurrentRestartType
            },
            ['RestartCauseRecords'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = systems_fru_ctrl_intf_types.RestartCauseRecords
            },
            ['RestartCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = systems_fru_ctrl_intf_types.RestartCount
            },
            ['PowerOnStrategy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['default'] = 'AlwaysPowerOn',
                ['validator'] = systems_fru_ctrl_intf_types.PowerOnStrategy
            },
            ['PowerOnStrategyExceptions'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = systems_fru_ctrl_intf_types.PowerOnStrategyExceptions
            },
            ['PanelPowerButtonEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['default'] = true,
                ['validator'] = systems_fru_ctrl_intf_types.PanelPowerButtonEnabled
            },
            ['GracefulShutdownTimeoutEnabled'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = systems_fru_ctrl_intf_types.GracefulShutdownTimeoutEnabled
            },
            ['GracefulShutdownTimeoutSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['default'] = 600,
                ['validator'] = systems_fru_ctrl_intf_types.GracefulShutdownTimeoutSeconds
            },
            ['GracefulShutdownDefaultTimeoutSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 600,
                ['validator'] = systems_fru_ctrl_intf_types.GracefulShutdownDefaultTimeoutSeconds
            },
            ['GracefulShutdownMaxTimeoutSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['default'] = 6000,
                ['validator'] = systems_fru_ctrl_intf_types.GracefulShutdownMaxTimeoutSeconds
            },
            ['GracefulShutdownMinTimeoutSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['default'] = 10,
                ['validator'] = systems_fru_ctrl_intf_types.GracefulShutdownMinTimeoutSeconds
            },
            ['HotswapState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_fru_ctrl_intf_types.HotswapState
            },
            ['LastPowerEvent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'ResetPer'},
                ['validator'] = systems_fru_ctrl_intf_types.LastPowerEvent
            },
            ['PowerCtrlFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'ResetPer'},
                ['validator'] = systems_fru_ctrl_intf_types.PowerCtrlFault
            },
            ['PowerCycleType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['validator'] = systems_fru_ctrl_intf_types.PowerCycleType
            },
            ['PreviousPowerState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['validator'] = systems_fru_ctrl_intf_types.PreviousPowerState
            },
            ['ACCycleEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = systems_fru_ctrl_intf_types.ACCycleEnabled
            }
        },
        ['bmc.kepler.Systems.ThermalTrip'] = {
            ['Action'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 1,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = thermal_trip_intf_types.Action
            },
            ['TimeDelaySeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minimum'] = 0,
                ['maximum'] = 1800,
                ['default'] = 300,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = thermal_trip_intf_types.TimeDelaySeconds
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.PowerOnLock'] = {
            ['SetPowerOnLock'] = {
                ['req'] = {
                    {['baseType'] = 'Boolean', ['param'] = 'PwrOnLocked'},
                    {['baseType'] = 'U32', ['param'] = 'Timeout'}, {['baseType'] = 'String', ['param'] = 'AppName'},
                    {['baseType'] = 'String', ['param'] = 'Reason'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Systems.FruCtrl'] = {
            ['PowerCtrl'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'PowerCtrlType'},
                    {['baseType'] = 'String', ['param'] = 'RestartCause'}
                },
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetPowerOnStrategyExceptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'Reason'}, {['baseType'] = 'String', ['param'] = 'Execute'},
                    {['baseType'] = 'String', ['param'] = 'EffectivePeriod'},
                    {['baseType'] = 'U8', ['param'] = 'Priority'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetACLost'] = {
                ['req'] = {{['baseType'] = 'U8', ['enum'] = {1}, ['param'] = 'Type'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['FruPowerCtrl'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'PowerCtrlType'},
                    {['baseType'] = 'String', ['param'] = 'RestartCause'}, {['baseType'] = 'U8', ['param'] = 'FruID'}
                },
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Systems.FruCtrl'] = {
            ['BeforePowerOnSignal'] = {{['baseType'] = 'U8', ['default'] = 3, ['param'] = 'Timeout'}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/FruCtrl/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerOnLock'] = {
            ['property_defaults'] = {
                ['PwrOnLocked'] = systems_power_on_lock_intf_types.PwrOnLocked.default[1],
                ['Reasons'] = systems_power_on_lock_intf_types.Reasons.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPowerOnLock'] = privilege.PowerMgmt}},
            ['interface_types'] = systems_power_on_lock_intf_types
        },
        ['bmc.kepler.Systems.DelayedPowerOnPolicy'] = {
            ['property_defaults'] = {
                ['Mode'] = 'DefaultDelay',
                ['Seconds'] = delayed_power_on_policy_intf_types.Seconds.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Mode'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['Seconds'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt}
                }
            },
            ['interface_types'] = delayed_power_on_policy_intf_types
        },
        ['bmc.kepler.Systems.FruCtrl'] = {
            ['property_defaults'] = {
                ['PowerState'] = systems_fru_ctrl_intf_types.PowerState.default[1],
                ['SysResetDetected'] = systems_fru_ctrl_intf_types.SysResetDetected.default[1],
                ['FruType'] = systems_fru_ctrl_intf_types.FruType.default[1],
                ['CurrentRestartCause'] = systems_fru_ctrl_intf_types.CurrentRestartCause.default[1],
                ['CurrentRestartCauseId'] = systems_fru_ctrl_intf_types.CurrentRestartCauseId.default[1],
                ['CurrentRestartType'] = 255,
                ['RestartCauseRecords'] = systems_fru_ctrl_intf_types.RestartCauseRecords.default[1],
                ['RestartCount'] = systems_fru_ctrl_intf_types.RestartCount.default[1],
                ['PowerOnStrategy'] = 'AlwaysPowerOn',
                ['PowerOnStrategyExceptions'] = systems_fru_ctrl_intf_types.PowerOnStrategyExceptions.default[1],
                ['PanelPowerButtonEnabled'] = true,
                ['GracefulShutdownTimeoutEnabled'] = systems_fru_ctrl_intf_types.GracefulShutdownTimeoutEnabled.default[1],
                ['GracefulShutdownTimeoutSeconds'] = 600,
                ['GracefulShutdownDefaultTimeoutSeconds'] = 600,
                ['GracefulShutdownMaxTimeoutSeconds'] = 6000,
                ['GracefulShutdownMinTimeoutSeconds'] = 10,
                ['HotswapState'] = systems_fru_ctrl_intf_types.HotswapState.default[1],
                ['LastPowerEvent'] = systems_fru_ctrl_intf_types.LastPowerEvent.default[1],
                ['PowerCtrlFault'] = systems_fru_ctrl_intf_types.PowerCtrlFault.default[1],
                ['PowerCycleType'] = systems_fru_ctrl_intf_types.PowerCycleType.default[1],
                ['PreviousPowerState'] = systems_fru_ctrl_intf_types.PreviousPowerState.default[1],
                ['ACCycleEnabled'] = systems_fru_ctrl_intf_types.ACCycleEnabled.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['PowerOnStrategy'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['PowerOnStrategyExceptions'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['PanelPowerButtonEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['GracefulShutdownTimeoutEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.PowerMgmt
                    },
                    ['GracefulShutdownTimeoutSeconds'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.PowerMgmt
                    },
                    ['ACCycleEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt}
                },
                ['methods'] = {
                    ['PowerCtrl'] = privilege.PowerMgmt,
                    ['SetPowerOnStrategyExceptions'] = privilege.PowerMgmt,
                    ['SetACLost'] = privilege.PowerMgmt,
                    ['FruPowerCtrl'] = privilege.PowerMgmt
                }
            },
            ['interface_types'] = systems_fru_ctrl_intf_types
        },
        ['bmc.kepler.Systems.ThermalTrip'] = {
            ['property_defaults'] = {['Action'] = 1, ['TimeDelaySeconds'] = 300},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Action'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['TimeDelaySeconds'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt}
                }
            },
            ['interface_types'] = thermal_trip_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local RecordFault = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = record_fault_class_types.FruID
        },
        ['IssueRecoredAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = record_fault_class_types.IssueRecoredAcc
        },
        ['LatchRecoredAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = record_fault_class_types.LatchRecoredAcc
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = record_fault_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['FruID'] = 0,
        ['IssueRecoredAcc'] = record_fault_class_types.IssueRecoredAcc.default[1],
        ['LatchRecoredAcc'] = record_fault_class_types.LatchRecoredAcc.default[1],
        ['IsValid'] = true
    }
}

local PGSignal = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = pg_signal_class_types.FruID
        },
        ['PowerGDState'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = pg_signal_class_types.PowerGDState
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = pg_signal_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['FruID'] = 0,
        ['PowerGDState'] = pg_signal_class_types.PowerGDState.default[1],
        ['IsValid'] = true
    }
}

local PowerButton = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = power_button_class_types.FruID
        },
        ['ShortPushButton'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = power_button_class_types.ShortPushButton
        },
        ['LongPushButton'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = power_button_class_types.LongPushButton
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = power_button_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['FruID'] = 0,
        ['ShortPushButton'] = power_button_class_types.ShortPushButton.default[1],
        ['LongPushButton'] = power_button_class_types.LongPushButton.default[1],
        ['IsValid'] = true
    }
}

local ACCycle = {
    ['prop_configs'] = {['AC'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ac_cycle_class_types.AC}},
    ['default_props'] = {['AC'] = ac_cycle_class_types.AC.default[1]}
}

local Nmi = {
    ['prop_configs'] = {
        ['FruID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['default'] = 0, ['validator'] = nmi_class_types.FruID},
        ['NmiInt'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = nmi_class_types.NmiInt},
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = nmi_class_types.IsValid
        }
    },
    ['default_props'] = {['FruID'] = 0, ['NmiInt'] = nmi_class_types.NmiInt.default[1], ['IsValid'] = true}
}

local ForceReset = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = force_reset_class_types.FruID
        },
        ['ForceRst'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = force_reset_class_types.ForceRst},
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = force_reset_class_types.IsValid
        }
    },
    ['default_props'] = {['FruID'] = 0, ['ForceRst'] = force_reset_class_types.ForceRst.default[1], ['IsValid'] = true}
}

local ButtonEvt = {
    ['table_name'] = 't_powerbtn_tb',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = button_evt_class_types.Id
        },
        ['PowerBtnLock'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = button_evt_class_types.PowerBtnLock
        },
        ['GetPowerBtnEvt'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = button_evt_class_types.GetPowerBtnEvt
        },
        ['SetPowerBtnEvt'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = button_evt_class_types.SetPowerBtnEvt
        },
        ['PowerBtnShield'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = button_evt_class_types.PowerBtnShield
        },
        ['PowerButtonShieldEnabled'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = button_evt_class_types.PowerButtonShieldEnabled
        }
    },
    ['default_props'] = {
        ['Id'] = button_evt_class_types.Id.default[1],
        ['PowerBtnLock'] = button_evt_class_types.PowerBtnLock.default[1],
        ['GetPowerBtnEvt'] = button_evt_class_types.GetPowerBtnEvt.default[1],
        ['SetPowerBtnEvt'] = button_evt_class_types.SetPowerBtnEvt.default[1],
        ['PowerBtnShield'] = button_evt_class_types.PowerBtnShield.default[1],
        ['PowerButtonShieldEnabled'] = false
    }
}

local SysReset = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = sys_reset_class_types.FruID
        },
        ['GetSysRstDetected'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = sys_reset_class_types.GetSysRstDetected
        },
        ['SetSysRstDetected'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = sys_reset_class_types.SetSysRstDetected
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = sys_reset_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['FruID'] = 0,
        ['GetSysRstDetected'] = sys_reset_class_types.GetSysRstDetected.default[1],
        ['SetSysRstDetected'] = sys_reset_class_types.SetSysRstDetected.default[1],
        ['IsValid'] = true
    }
}

local ThermTrip = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = therm_trip_class_types.FruID
        },
        ['GetThermTrip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = therm_trip_class_types.GetThermTrip
        },
        ['SetThermTrip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = therm_trip_class_types.SetThermTrip
        },
        ['GetThermTrip2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = therm_trip_class_types.GetThermTrip2
        },
        ['SetThermTrip2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = therm_trip_class_types.SetThermTrip2
        },
        ['Actions'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = therm_trip_class_types.Actions
        },
        ['TimeDelaySeconds'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 300,
            ['validator'] = therm_trip_class_types.TimeDelaySeconds
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = therm_trip_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['FruID'] = 0,
        ['GetThermTrip'] = therm_trip_class_types.GetThermTrip.default[1],
        ['SetThermTrip'] = therm_trip_class_types.SetThermTrip.default[1],
        ['GetThermTrip2'] = therm_trip_class_types.GetThermTrip2.default[1],
        ['SetThermTrip2'] = therm_trip_class_types.SetThermTrip2.default[1],
        ['Actions'] = 1,
        ['TimeDelaySeconds'] = 300,
        ['IsValid'] = true
    }
}

local DftPowerButton = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'ConfigureSelf'}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'ConfigureSelf'}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                },
                ['privilege'] = {'ConfigureSelf'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftPowerButton/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['Start'] = privilege.ConfigureSelf,
                    ['Stop'] = privilege.ConfigureSelf,
                    ['GetResult'] = privilege.ConfigureSelf
                }
            },
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SystemLockDown = {
    ['table_name'] = 't_system_lockdown',
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = system_lock_down_class_types.FruID
        },
        ['SystemId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = system_lock_down_class_types.SystemId
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = system_lock_down_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['FruID'] = 0,
        ['SystemId'] = system_lock_down_class_types.SystemId.default[1],
        ['IsValid'] = true
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.SystemLockDown'] = {
            ['SystemLockDownSupport'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['enum'] = {'Supported', 'Unsupported'},
                ['default'] = 'Unsupported',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = system_lock_down_intf_types.SystemLockDownSupport
            },
            ['SystemLockDownStatus'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['enum'] = {'Locked', 'Unlocked'},
                ['default'] = 'Unlocked',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'UserMgmt'}},
                ['validator'] = system_lock_down_intf_types.SystemLockDownStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.SystemLockDown'] = {
            ['property_defaults'] = {['SystemLockDownSupport'] = 'Unsupported', ['SystemLockDownStatus'] = 'Unlocked'},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['SystemLockDownSupport'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt},
                    ['SystemLockDownStatus'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.UserMgmt}
                }
            },
            ['interface_types'] = system_lock_down_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerAction = {
    ['prop_configs'] = {
        ['FruID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = power_action_class_types.FruID
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = power_action_class_types.IsValid
        }
    },
    ['default_props'] = {['FruID'] = 0, ['IsValid'] = true},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerAction'] = {
            ['PowerOnTimeoutFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = power_action_intf_types.PowerOnTimeoutFlag
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PowerAction'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerAction'] = {
            ['property_defaults'] = {['PowerOnTimeoutFlag'] = power_action_intf_types.PowerOnTimeoutFlag.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = power_action_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Multihost = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Managers.Multihost'] = {
            ['HostType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Singlehost',
                ['enum'] = {'Singlehost', 'Multihost'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = multihost_intf_types.HostType
            },
            ['HostCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 1,
                ['minimum'] = 1,
                ['maximum'] = 63,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = multihost_intf_types.HostCount
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Managers/:ManagerId/Multihost'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Managers.Multihost'] = {
            ['property_defaults'] = {['HostType'] = 'Singlehost', ['HostCount'] = 1},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = multihost_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local FruCtrlCapabilities = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ProductInfo.FruCtrlCapabilities'] = {
            ['GlobalDomainSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fru_ctrl_capabilities_intf_types.GlobalDomainSupported
            },
            ['MultihostSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fru_ctrl_capabilities_intf_types.MultihostSupported
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ProductInfo/FruCtrlCapabilities'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ProductInfo.FruCtrlCapabilities'] = {
            ['property_defaults'] = {
                ['GlobalDomainSupported'] = fru_ctrl_capabilities_intf_types.GlobalDomainSupported.default[1],
                ['MultihostSupported'] = fru_ctrl_capabilities_intf_types.MultihostSupported.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = fru_ctrl_capabilities_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('ChassisFruCtrl', ChassisFruCtrl):set_bus(bus)
    class('FruCtrl', FruCtrl):set_bus(bus)
    class('RecordFault', RecordFault):set_bus(bus)
    class('PGSignal', PGSignal):set_bus(bus)
    class('PowerButton', PowerButton):set_bus(bus)
    class('ACCycle', ACCycle):set_bus(bus)
    class('Nmi', Nmi):set_bus(bus)
    class('ForceReset', ForceReset):set_bus(bus)
    class('ButtonEvt', ButtonEvt):set_bus(bus)
    class('SysReset', SysReset):set_bus(bus)
    class('ThermTrip', ThermTrip):set_bus(bus)
    class('DftPowerButton', DftPowerButton):set_bus(bus)
    class('SystemLockDown', SystemLockDown):set_bus(bus)
    class('PowerAction', PowerAction):set_bus(bus)
    class('Multihost', Multihost):set_bus(bus)
    class('FruCtrlCapabilities', FruCtrlCapabilities):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplChassisFruCtrlChassisFruCtrlPowerCtrl(cb)
    class('ChassisFruCtrl')['bmc.kepler.Chassis.FruCtrl'].PowerCtrl = function(obj, ctx, ...)
        local req = chassis_fru_ctrl_intf_types.PowerCtrlReq.new(...):validate(nil, nil, true)
        local rsp = chassis_fru_ctrl_intf_types.PowerCtrlRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisFruCtrlChassisFruCtrlSetPowerOnStrategyExceptions(cb)
    class('ChassisFruCtrl')['bmc.kepler.Chassis.FruCtrl'].SetPowerOnStrategyExceptions = function(obj, ctx, ...)
        local req = chassis_fru_ctrl_intf_types.SetPowerOnStrategyExceptionsReq.new(...):validate(nil, nil, true)
        local rsp =
            chassis_fru_ctrl_intf_types.SetPowerOnStrategyExceptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisFruCtrlChassisPowerOnLockSetPowerOnLock(cb)
    class('ChassisFruCtrl')['bmc.kepler.Chassis.PowerOnLock'].SetPowerOnLock = function(obj, ctx, ...)
        local req = chassis_power_on_lock_intf_types.SetPowerOnLockReq.new(...):validate(nil, nil, true)
        local rsp = chassis_power_on_lock_intf_types.SetPowerOnLockRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFruCtrlSystemsPowerOnLockSetPowerOnLock(cb)
    class('FruCtrl')['bmc.kepler.Systems.PowerOnLock'].SetPowerOnLock = function(obj, ctx, ...)
        local req = systems_power_on_lock_intf_types.SetPowerOnLockReq.new(...):validate(nil, nil, true)
        local rsp = systems_power_on_lock_intf_types.SetPowerOnLockRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFruCtrlSystemsFruCtrlPowerCtrl(cb)
    class('FruCtrl')['bmc.kepler.Systems.FruCtrl'].PowerCtrl = function(obj, ctx, ...)
        local req = systems_fru_ctrl_intf_types.PowerCtrlReq.new(...):validate(nil, nil, true)
        local rsp = systems_fru_ctrl_intf_types.PowerCtrlRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFruCtrlSystemsFruCtrlSetPowerOnStrategyExceptions(cb)
    class('FruCtrl')['bmc.kepler.Systems.FruCtrl'].SetPowerOnStrategyExceptions = function(obj, ctx, ...)
        local req = systems_fru_ctrl_intf_types.SetPowerOnStrategyExceptionsReq.new(...):validate(nil, nil, true)
        local rsp =
            systems_fru_ctrl_intf_types.SetPowerOnStrategyExceptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFruCtrlSystemsFruCtrlSetACLost(cb)
    class('FruCtrl')['bmc.kepler.Systems.FruCtrl'].SetACLost = function(obj, ctx, ...)
        local req = systems_fru_ctrl_intf_types.SetACLostReq.new(...):validate(nil, nil, true)
        local rsp = systems_fru_ctrl_intf_types.SetACLostRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFruCtrlSystemsFruCtrlFruPowerCtrl(cb)
    class('FruCtrl')['bmc.kepler.Systems.FruCtrl'].FruPowerCtrl = function(obj, ctx, ...)
        local req = systems_fru_ctrl_intf_types.FruPowerCtrlReq.new(...):validate(nil, nil, true)
        local rsp = systems_fru_ctrl_intf_types.FruPowerCtrlRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerButtonManufactureStart(cb)
    class('DftPowerButton')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerButtonManufactureStop(cb)
    class('DftPowerButton')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerButtonManufactureGetResult(cb)
    class('DftPowerButton')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
