-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local led_object = require 'led_object'
local skynet = require 'skynet'
local chassis_service = require 'chassis_service'
local chassis_object = require 'chassis_object'
local led_i2c_object = require 'led_i2c_object'


TestUIDLedServcie = {}

function TestUIDLedServcie:test_set_uid_led()
    -- 测试state为0时 关闭状态
    local on_duration, off_duration = led_object:get_onoffduration_by_state(0)
    lu.assertEquals(on_duration, 0)
    lu.assertEquals(off_duration, 0)
    -- 当state为5时 闪烁状态
    on_duration, off_duration = led_object:get_onoffduration_by_state(5)
    lu.assertEquals(on_duration, 50)
    lu.assertEquals(off_duration, 50)
    -- 测试当state为255时 点亮状态
    on_duration, off_duration = led_object:get_onoffduration_by_state(255)
    lu.assertEquals(on_duration, 255)
    lu.assertEquals(off_duration, 0)
end

function TestUIDLedServcie:test_uid_led_reverse()
    local service = chassis_service.new()
    local obj = {
        Name = "1",
        IntrusionACOn = 0,
        IntrusionACOff = 0,
        CoverStatus = 0,
        IntrusionClear = 0,
        IntrusionFlag = 0,
        LastIntrusionACOn = 0,
        UidButtonLongScanner = 1,
        ['bmc.kepler.Chassis'] = {
            ['enable_shm_prop_cache'] = function (...)
            end
        }
    }
    service:add_object(obj)
    -- -- 测试uid长按事件
    local old_fork = skynet.fork
    skynet.fork = function (cb)
        cb()
    end

    local ok, _ = pcall(service.long_press_uid_check_task, service)
    lu.assertEquals(ok, false)

    skynet.fork = old_fork

    service.led_service = {}
    service.led_service.set_led = function(...)
        return true
    end
    -- 测试state为0时 关闭状态
    service.led_service.get_led_obj = function(...)
        return {get_led_state = function(...) 
            return 0
        end}
    end
    ok = pcall(service.led_reverse, service)
    lu.assertEquals(ok, true)
    service.led_object = nil

    -- 测试当state为255时 点亮状态
    service.led_service.get_led_obj = function(...)
        return {get_led_state = function(...) 
            return 255
        end}
    end
    ok = pcall(service.led_reverse, service)
    lu.assertEquals(ok, true)

    service.led_service = nil
    service.led_object = nil
end

function TestUIDLedServcie:test_set_state()
    local mds_obj = {
        LedOnValue = 0xff,
        CtrlValue = 0
    }
    local obj = led_i2c_object.new(mds_obj)
    local ok = pcall(led_i2c_object.set_state, obj, 0xff, 100, 100)
    lu.assertEquals(ok, true)

    local ok = pcall(led_i2c_object.set_state, obj, 0, 100, 100)
    lu.assertEquals(ok, true)
end