-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local chassis_def = {}

chassis_def.UIDLEDMODE = {
    LED_MODE_BLINK = 1,
    LED_MODE_OFF = 0,
    LED_MODE_ON = 2
}

chassis_def.UIDLEDSTATE = {
    LED_ON = 0xFF,
    LED_OFF = 0,
    LED_BLINK = 5
}

chassis_def.UIDLEDINTERVAL = {
    LED_INTERVAl_ON = 0xFF,
    LED_IDENTIFY_INTERVAL_ON = 50,
    LED_IDENTIFY_INTERVAL_OFF = 50
}

chassis_def.LED_FUN = {
    OS_OFF      = 0,
    OS_ON       = 0xff,
    LCS         = 0xfc,
    LAMPTEST    = 0xfb
}

chassis_def.LED_CONTROL_MODE = {
    LCS         = 0,
    OS          = 1,
    LAMPTEST    = 2,
    STARTUP     = 4
}

chassis_def.LEDCOLOR = {
    RESERVED    = 0,
    BLUE        = 1,
    RED         = 2,
    GREEN       = 3,
    AMBER       = 4,
    ORANGE      = 5,
    WHITE       = 6,
    NOT_CHANGE  = 0xE,
    DEFAULT     = 0xF
}

chassis_def.LED_COLOR_STR = {
    [0] = "reserved",
    [1] = "BLUE",
    [2] = "RED",
    [3] = "GREEN",
    [4] = "AMBER",
    [5] = "ORANGE",
    [6] = "WHITE",
}

chassis_def.REGISTERVAlUE = {
    UID_BLINK = 85,
    UID_ON = 144,
    UID_OFF = 0
}

chassis_def.COVER_CODE = {
    COVER_UNKOWN_VALUE = 0xff,
    OPEN_DEFAULT_VALUE = 0,
    TIME_DELAY = 10,
    CLOSED = 0,
    OPENED = 1,
    CLOSED_VALUE = 0,
    OPENED_VALUE = 1,
    OPEN_CLEAR = 1,
    OPEN_STR = "Chassis cover opened",
    CLOSE_STR = "Chassis cover closed",
    OPEN_AC_CLEAR = 0x08,
    OPEN_DC_CLEAR = 0x04
}

chassis_def.RET = {
    OK  = 0,
    ERR = -1
}

chassis_def.CHASSIS_IDENTIFY_STATE = {
    OFF     = 0,
    ON      = 0X20,
    TIMED   = 0X10
}

chassis_def.DEVICEID_MAP = {
    [1] = 'PCIeNCSIEnabled',
    [2] = 'SWRAIDEnable',
    [5] = 'WOLState',
    [9] = 'WeakPwdDictSupport',
    [10] = 'VMDState',
    [13] = 'PCIeNCSISupported',
    [14] = 'VGASwitch'
}

chassis_def.LED_MODE_STR = {
    [0] = 'Local Control',
    [1] = 'Override',
    [2] = 'Lamp Test'
}

chassis_def.CHASSIS_TYPE = {
    RACK        = 0,    -- 机架管理
    X_SERIAL    = 1,    -- 高密计算节点
    BLADE       = 2,    -- 刀片计算节点
    SWITCH      = 3,    -- 交换节点
    MM          = 4,    -- 机框/柜外围部件
    CMC         = 5,    -- 机框/柜集中管理
    RM          = 6     -- 机柜管理
}

chassis_def.SERVER_TYPE = {
    SERVER_TYPE_CHASSIS     = 0,
    SERVER_TYPE_BLADE       = 1
}

return chassis_def