-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSuperPodLabel = {}

---@class MSuperPodLabel.Crc16
---@field Crc16 integer
local TCrc16 = {}
TCrc16.__index = TCrc16
TCrc16.group = {}

local function TCrc16_from_obj(obj)
    return setmetatable(obj, TCrc16)
end

function TCrc16.new(Crc16)
    return TCrc16_from_obj({Crc16 = Crc16 or 0})
end
---@param obj MSuperPodLabel.Crc16
function TCrc16:init_from_obj(obj)
    self.Crc16 = obj.Crc16 or 0
end

function TCrc16:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCrc16.group)
end

TCrc16.from_obj = TCrc16_from_obj

TCrc16.proto_property = {'Crc16'}

TCrc16.default = {0}

TCrc16.struct = {{name = 'Crc16', is_array = false, struct = nil}}

function TCrc16:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Crc16', self.Crc16, 'uint16', false, errs, need_convert)

    TCrc16:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCrc16.proto_property, errs, need_convert)
    return self
end

function TCrc16:unpack(_)
    return self.Crc16
end

MSuperPodLabel.Crc16 = TCrc16

---@class MSuperPodLabel.DefaultSuperPodSize
---@field DefaultSuperPodSize integer
local TDefaultSuperPodSize = {}
TDefaultSuperPodSize.__index = TDefaultSuperPodSize
TDefaultSuperPodSize.group = {}

local function TDefaultSuperPodSize_from_obj(obj)
    return setmetatable(obj, TDefaultSuperPodSize)
end

function TDefaultSuperPodSize.new(DefaultSuperPodSize)
    return TDefaultSuperPodSize_from_obj({DefaultSuperPodSize = DefaultSuperPodSize or 384})
end
---@param obj MSuperPodLabel.DefaultSuperPodSize
function TDefaultSuperPodSize:init_from_obj(obj)
    self.DefaultSuperPodSize = obj.DefaultSuperPodSize or 384
end

function TDefaultSuperPodSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultSuperPodSize.group)
end

TDefaultSuperPodSize.from_obj = TDefaultSuperPodSize_from_obj

TDefaultSuperPodSize.proto_property = {'DefaultSuperPodSize'}

TDefaultSuperPodSize.default = {0}

TDefaultSuperPodSize.struct = {{name = 'DefaultSuperPodSize', is_array = false, struct = nil}}

function TDefaultSuperPodSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultSuperPodSize', self.DefaultSuperPodSize, 'uint16', false, errs, need_convert)

    TDefaultSuperPodSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultSuperPodSize.proto_property, errs, need_convert)
    return self
end

function TDefaultSuperPodSize:unpack(_)
    return self.DefaultSuperPodSize
end

MSuperPodLabel.DefaultSuperPodSize = TDefaultSuperPodSize

---@class MSuperPodLabel.DefaultServerIndex
---@field DefaultServerIndex integer
local TDefaultServerIndex = {}
TDefaultServerIndex.__index = TDefaultServerIndex
TDefaultServerIndex.group = {}

local function TDefaultServerIndex_from_obj(obj)
    return setmetatable(obj, TDefaultServerIndex)
end

function TDefaultServerIndex.new(DefaultServerIndex)
    return TDefaultServerIndex_from_obj({DefaultServerIndex = DefaultServerIndex or 65535})
end
---@param obj MSuperPodLabel.DefaultServerIndex
function TDefaultServerIndex:init_from_obj(obj)
    self.DefaultServerIndex = obj.DefaultServerIndex or 65535
end

function TDefaultServerIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultServerIndex.group)
end

TDefaultServerIndex.from_obj = TDefaultServerIndex_from_obj

TDefaultServerIndex.proto_property = {'DefaultServerIndex'}

TDefaultServerIndex.default = {0}

TDefaultServerIndex.struct = {{name = 'DefaultServerIndex', is_array = false, struct = nil}}

function TDefaultServerIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultServerIndex', self.DefaultServerIndex, 'uint16', false, errs, need_convert)

    TDefaultServerIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultServerIndex.proto_property, errs, need_convert)
    return self
end

function TDefaultServerIndex:unpack(_)
    return self.DefaultServerIndex
end

MSuperPodLabel.DefaultServerIndex = TDefaultServerIndex

---@class MSuperPodLabel.DefaultSuperPodId
---@field DefaultSuperPodId integer
local TDefaultSuperPodId = {}
TDefaultSuperPodId.__index = TDefaultSuperPodId
TDefaultSuperPodId.group = {}

local function TDefaultSuperPodId_from_obj(obj)
    return setmetatable(obj, TDefaultSuperPodId)
end

function TDefaultSuperPodId.new(DefaultSuperPodId)
    return TDefaultSuperPodId_from_obj({DefaultSuperPodId = DefaultSuperPodId or 4294967295})
end
---@param obj MSuperPodLabel.DefaultSuperPodId
function TDefaultSuperPodId:init_from_obj(obj)
    self.DefaultSuperPodId = obj.DefaultSuperPodId or 4294967295
end

function TDefaultSuperPodId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultSuperPodId.group)
end

TDefaultSuperPodId.from_obj = TDefaultSuperPodId_from_obj

TDefaultSuperPodId.proto_property = {'DefaultSuperPodId'}

TDefaultSuperPodId.default = {0}

TDefaultSuperPodId.struct = {{name = 'DefaultSuperPodId', is_array = false, struct = nil}}

function TDefaultSuperPodId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultSuperPodId', self.DefaultSuperPodId, 'uint32', false, errs, need_convert)

    TDefaultSuperPodId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultSuperPodId.proto_property, errs, need_convert)
    return self
end

function TDefaultSuperPodId:unpack(_)
    return self.DefaultSuperPodId
end

MSuperPodLabel.DefaultSuperPodId = TDefaultSuperPodId

---@class MSuperPodLabel.SuperPodSizeAcc
---@field SuperPodSizeAcc integer
local TSuperPodSizeAcc = {}
TSuperPodSizeAcc.__index = TSuperPodSizeAcc
TSuperPodSizeAcc.group = {}

local function TSuperPodSizeAcc_from_obj(obj)
    return setmetatable(obj, TSuperPodSizeAcc)
end

function TSuperPodSizeAcc.new(SuperPodSizeAcc)
    return TSuperPodSizeAcc_from_obj({SuperPodSizeAcc = SuperPodSizeAcc})
end
---@param obj MSuperPodLabel.SuperPodSizeAcc
function TSuperPodSizeAcc:init_from_obj(obj)
    self.SuperPodSizeAcc = obj.SuperPodSizeAcc
end

function TSuperPodSizeAcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSuperPodSizeAcc.group)
end

TSuperPodSizeAcc.from_obj = TSuperPodSizeAcc_from_obj

TSuperPodSizeAcc.proto_property = {'SuperPodSizeAcc'}

TSuperPodSizeAcc.default = {0}

TSuperPodSizeAcc.struct = {{name = 'SuperPodSizeAcc', is_array = false, struct = nil}}

function TSuperPodSizeAcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodSizeAcc', self.SuperPodSizeAcc, 'uint16', false, errs, need_convert)

    TSuperPodSizeAcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSuperPodSizeAcc.proto_property, errs, need_convert)
    return self
end

function TSuperPodSizeAcc:unpack(_)
    return self.SuperPodSizeAcc
end

MSuperPodLabel.SuperPodSizeAcc = TSuperPodSizeAcc

---@class MSuperPodLabel.ServerIndexAcc
---@field ServerIndexAcc integer
local TServerIndexAcc = {}
TServerIndexAcc.__index = TServerIndexAcc
TServerIndexAcc.group = {}

local function TServerIndexAcc_from_obj(obj)
    return setmetatable(obj, TServerIndexAcc)
end

function TServerIndexAcc.new(ServerIndexAcc)
    return TServerIndexAcc_from_obj({ServerIndexAcc = ServerIndexAcc})
end
---@param obj MSuperPodLabel.ServerIndexAcc
function TServerIndexAcc:init_from_obj(obj)
    self.ServerIndexAcc = obj.ServerIndexAcc
end

function TServerIndexAcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TServerIndexAcc.group)
end

TServerIndexAcc.from_obj = TServerIndexAcc_from_obj

TServerIndexAcc.proto_property = {'ServerIndexAcc'}

TServerIndexAcc.default = {0}

TServerIndexAcc.struct = {{name = 'ServerIndexAcc', is_array = false, struct = nil}}

function TServerIndexAcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServerIndexAcc', self.ServerIndexAcc, 'uint16', false, errs, need_convert)

    TServerIndexAcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TServerIndexAcc.proto_property, errs, need_convert)
    return self
end

function TServerIndexAcc:unpack(_)
    return self.ServerIndexAcc
end

MSuperPodLabel.ServerIndexAcc = TServerIndexAcc

---@class MSuperPodLabel.SuperPodIdAcc
---@field SuperPodIdAcc integer
local TSuperPodIdAcc = {}
TSuperPodIdAcc.__index = TSuperPodIdAcc
TSuperPodIdAcc.group = {}

local function TSuperPodIdAcc_from_obj(obj)
    return setmetatable(obj, TSuperPodIdAcc)
end

function TSuperPodIdAcc.new(SuperPodIdAcc)
    return TSuperPodIdAcc_from_obj({SuperPodIdAcc = SuperPodIdAcc})
end
---@param obj MSuperPodLabel.SuperPodIdAcc
function TSuperPodIdAcc:init_from_obj(obj)
    self.SuperPodIdAcc = obj.SuperPodIdAcc
end

function TSuperPodIdAcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSuperPodIdAcc.group)
end

TSuperPodIdAcc.from_obj = TSuperPodIdAcc_from_obj

TSuperPodIdAcc.proto_property = {'SuperPodIdAcc'}

TSuperPodIdAcc.default = {0}

TSuperPodIdAcc.struct = {{name = 'SuperPodIdAcc', is_array = false, struct = nil}}

function TSuperPodIdAcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodIdAcc', self.SuperPodIdAcc, 'uint32', false, errs, need_convert)

    TSuperPodIdAcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSuperPodIdAcc.proto_property, errs, need_convert)
    return self
end

function TSuperPodIdAcc:unpack(_)
    return self.SuperPodIdAcc
end

MSuperPodLabel.SuperPodIdAcc = TSuperPodIdAcc

---@class MSuperPodLabel.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 1})
end
---@param obj MSuperPodLabel.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 1
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MSuperPodLabel.Id = TId

return MSuperPodLabel
