-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLed = {}

---@class MLed.LampTestDuration
---@field LampTestDuration integer
local TLampTestDuration = {}
TLampTestDuration.__index = TLampTestDuration
TLampTestDuration.group = {}

local function TLampTestDuration_from_obj(obj)
    return setmetatable(obj, TLampTestDuration)
end

function TLampTestDuration.new(LampTestDuration)
    return TLampTestDuration_from_obj({LampTestDuration = LampTestDuration})
end
---@param obj MLed.LampTestDuration
function TLampTestDuration:init_from_obj(obj)
    self.LampTestDuration = obj.LampTestDuration
end

function TLampTestDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLampTestDuration.group)
end

TLampTestDuration.from_obj = TLampTestDuration_from_obj

TLampTestDuration.proto_property = {'LampTestDuration'}

TLampTestDuration.default = {0}

TLampTestDuration.struct = {{name = 'LampTestDuration', is_array = false, struct = nil}}

function TLampTestDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LampTestDuration', self.LampTestDuration, 'uint8', false, errs, need_convert)

    TLampTestDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLampTestDuration.proto_property, errs, need_convert)
    return self
end

function TLampTestDuration:unpack(_)
    return self.LampTestDuration
end

MLed.LampTestDuration = TLampTestDuration

---@class MLed.LampTestColor
---@field LampTestColor integer
local TLampTestColor = {}
TLampTestColor.__index = TLampTestColor
TLampTestColor.group = {}

local function TLampTestColor_from_obj(obj)
    return setmetatable(obj, TLampTestColor)
end

function TLampTestColor.new(LampTestColor)
    return TLampTestColor_from_obj({LampTestColor = LampTestColor})
end
---@param obj MLed.LampTestColor
function TLampTestColor:init_from_obj(obj)
    self.LampTestColor = obj.LampTestColor
end

function TLampTestColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLampTestColor.group)
end

TLampTestColor.from_obj = TLampTestColor_from_obj

TLampTestColor.proto_property = {'LampTestColor'}

TLampTestColor.default = {0}

TLampTestColor.struct = {{name = 'LampTestColor', is_array = false, struct = nil}}

function TLampTestColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LampTestColor', self.LampTestColor, 'uint8', false, errs, need_convert)

    TLampTestColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLampTestColor.proto_property, errs, need_convert)
    return self
end

function TLampTestColor:unpack(_)
    return self.LampTestColor
end

MLed.LampTestColor = TLampTestColor

---@class MLed.OSState
---@field OSState integer
local TOSState = {}
TOSState.__index = TOSState
TOSState.group = {}

local function TOSState_from_obj(obj)
    return setmetatable(obj, TOSState)
end

function TOSState.new(OSState)
    return TOSState_from_obj({OSState = OSState})
end
---@param obj MLed.OSState
function TOSState:init_from_obj(obj)
    self.OSState = obj.OSState
end

function TOSState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOSState.group)
end

TOSState.from_obj = TOSState_from_obj

TOSState.proto_property = {'OSState'}

TOSState.default = {0}

TOSState.struct = {{name = 'OSState', is_array = false, struct = nil}}

function TOSState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OSState', self.OSState, 'uint8', false, errs, need_convert)

    TOSState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOSState.proto_property, errs, need_convert)
    return self
end

function TOSState:unpack(_)
    return self.OSState
end

MLed.OSState = TOSState

---@class MLed.OSColor
---@field OSColor integer
local TOSColor = {}
TOSColor.__index = TOSColor
TOSColor.group = {}

local function TOSColor_from_obj(obj)
    return setmetatable(obj, TOSColor)
end

function TOSColor.new(OSColor)
    return TOSColor_from_obj({OSColor = OSColor})
end
---@param obj MLed.OSColor
function TOSColor:init_from_obj(obj)
    self.OSColor = obj.OSColor
end

function TOSColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOSColor.group)
end

TOSColor.from_obj = TOSColor_from_obj

TOSColor.proto_property = {'OSColor'}

TOSColor.default = {0}

TOSColor.struct = {{name = 'OSColor', is_array = false, struct = nil}}

function TOSColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OSColor', self.OSColor, 'uint8', false, errs, need_convert)

    TOSColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOSColor.proto_property, errs, need_convert)
    return self
end

function TOSColor:unpack(_)
    return self.OSColor
end

MLed.OSColor = TOSColor

---@class MLed.LCSState
---@field LCSState integer
local TLCSState = {}
TLCSState.__index = TLCSState
TLCSState.group = {}

local function TLCSState_from_obj(obj)
    return setmetatable(obj, TLCSState)
end

function TLCSState.new(LCSState)
    return TLCSState_from_obj({LCSState = LCSState})
end
---@param obj MLed.LCSState
function TLCSState:init_from_obj(obj)
    self.LCSState = obj.LCSState
end

function TLCSState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLCSState.group)
end

TLCSState.from_obj = TLCSState_from_obj

TLCSState.proto_property = {'LCSState'}

TLCSState.default = {0}

TLCSState.struct = {{name = 'LCSState', is_array = false, struct = nil}}

function TLCSState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LCSState', self.LCSState, 'uint8', false, errs, need_convert)

    TLCSState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLCSState.proto_property, errs, need_convert)
    return self
end

function TLCSState:unpack(_)
    return self.LCSState
end

MLed.LCSState = TLCSState

---@class MLed.LCSColor
---@field LCSColor integer
local TLCSColor = {}
TLCSColor.__index = TLCSColor
TLCSColor.group = {}

local function TLCSColor_from_obj(obj)
    return setmetatable(obj, TLCSColor)
end

function TLCSColor.new(LCSColor)
    return TLCSColor_from_obj({LCSColor = LCSColor})
end
---@param obj MLed.LCSColor
function TLCSColor:init_from_obj(obj)
    self.LCSColor = obj.LCSColor
end

function TLCSColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLCSColor.group)
end

TLCSColor.from_obj = TLCSColor_from_obj

TLCSColor.proto_property = {'LCSColor'}

TLCSColor.default = {0}

TLCSColor.struct = {{name = 'LCSColor', is_array = false, struct = nil}}

function TLCSColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LCSColor', self.LCSColor, 'uint8', false, errs, need_convert)

    TLCSColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLCSColor.proto_property, errs, need_convert)
    return self
end

function TLCSColor:unpack(_)
    return self.LCSColor
end

MLed.LCSColor = TLCSColor

---@class MLed.CtrlValue
---@field CtrlValue integer
local TCtrlValue = {}
TCtrlValue.__index = TCtrlValue
TCtrlValue.group = {}

local function TCtrlValue_from_obj(obj)
    return setmetatable(obj, TCtrlValue)
end

function TCtrlValue.new(CtrlValue)
    return TCtrlValue_from_obj({CtrlValue = CtrlValue})
end
---@param obj MLed.CtrlValue
function TCtrlValue:init_from_obj(obj)
    self.CtrlValue = obj.CtrlValue
end

function TCtrlValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlValue.group)
end

TCtrlValue.from_obj = TCtrlValue_from_obj

TCtrlValue.proto_property = {'CtrlValue'}

TCtrlValue.default = {0}

TCtrlValue.struct = {{name = 'CtrlValue', is_array = false, struct = nil}}

function TCtrlValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlValue', self.CtrlValue, 'uint8', false, errs, need_convert)

    if self.CtrlValue ~= nil then
        validate.ranges(prefix .. 'CtrlValue', self.CtrlValue, 0, 255, errs, need_convert)
    end

    TCtrlValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlValue.proto_property, errs, need_convert)
    return self
end

function TCtrlValue:unpack(_)
    return self.CtrlValue
end

MLed.CtrlValue = TCtrlValue

return MLed
