-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local led_policy_class_types = require 'class.types.LedPolicy'
local led_class_types = require 'class.types.Led'
local chassis_class_types = require 'class.types.Chassis'
local led_disp_control_class_types = require 'class.types.LedDispControl'
local i2c_led_class_types = require 'class.types.I2cLed'
local dft_pysical_led_class_types = require 'class.types.DftPysicalLed'
local dft_led_intelligence_class_types = require 'class.types.DftLedIntelligence'
local chassis_table_class_types = require 'class.types.ChassisTable'
local super_pod_label_class_types = require 'class.types.SuperPodLabel'
local dft_button_test_class_types = require 'class.types.DftButtonTest'
local policy_intf_types = require 'chassis.json_types.Policy'
local system_health_intf_types = require 'chassis.json_types.SystemHealth'
local properties_intf_types = require 'chassis.json_types.Properties'
local led_intf_types = require 'chassis.json_types.Led'
local dimension_intf_types = require 'chassis.json_types.Dimension'
local chassis_intf_types = require 'chassis.json_types.Chassis'
local metric_intf_types = require 'chassis.json_types.Metric'
local manufacture_intf_types = require 'chassis.json_types.Manufacture'
local ncsi_capabilities_intf_types = require 'chassis.json_types.NCSICapabilities'
local super_pod_label_intf_types = require 'chassis.json_types.SuperPodLabel'
local enclosure_intf_types = require 'chassis.json_types.Enclosure'

local LedPolicy = {
    ['table_name'] = 't_LedPolicy',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['readOnly'] = true,
            ['default'] = 1,
            ['validator'] = led_policy_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Led.Policy'] = {
            ['Normal'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Normal
            },
            ['Minor'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Minor
            },
            ['Major'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Major
            },
            ['Critical'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['validator'] = policy_intf_types.Critical
            }
        },
        ['bmc.kepler.Systems.Led.Policy.SystemHealth'] = {
            ['SeverityReferenceSource'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Event', 'Sensor', 'EventAndSensor'},
                ['usage'] = {'TemporaryPer'},
                ['default'] = 'Event',
                ['validator'] = system_health_intf_types.SeverityReferenceSource
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Leds'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Led.Policy'] = {
            ['property_defaults'] = {
                ['Normal'] = policy_intf_types.Normal.default[1],
                ['Minor'] = policy_intf_types.Minor.default[1],
                ['Major'] = policy_intf_types.Major.default[1],
                ['Critical'] = policy_intf_types.Critical.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = policy_intf_types
        },
        ['bmc.kepler.Systems.Led.Policy.SystemHealth'] = {
            ['property_defaults'] = {['SeverityReferenceSource'] = 'Event'},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = system_health_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Led = {
    ['table_name'] = 't_Led',
    ['prop_configs'] = {
        ['CtrlValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['minimum'] = 0,
            ['maximum'] = 255,
            ['validator'] = led_class_types.CtrlValue
        },
        ['LCSColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.LCSColor},
        ['LCSState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.LCSState},
        ['OSColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.OSColor},
        ['OSState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.OSState},
        ['LampTestColor'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = led_class_types.LampTestColor},
        ['LampTestDuration'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = led_class_types.LampTestDuration
        }
    },
    ['default_props'] = {
        ['CtrlValue'] = led_class_types.CtrlValue.default[1],
        ['LCSColor'] = led_class_types.LCSColor.default[1],
        ['LCSState'] = led_class_types.LCSState.default[1],
        ['OSColor'] = led_class_types.OSColor.default[1],
        ['OSState'] = led_class_types.OSState.default[1],
        ['LampTestColor'] = led_class_types.LampTestColor.default[1],
        ['LampTestDuration'] = led_class_types.LampTestDuration.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Led'] = {
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.SystemId
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.Name
            },
            ['OnDuration'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['validator'] = led_intf_types.OnDuration
            },
            ['OffDuration'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['validator'] = led_intf_types.OffDuration
            },
            ['Capability'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.Capability
            },
            ['State'] = {
                ['baseType'] = 'U8',
                ['usage'] = {'ResetPer'},
                ['validator'] = led_intf_types.State
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = led_intf_types.Id
            },
            ['FruId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.FruId
            },
            ['ColorCapabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.ColorCapabilities
            },
            ['LocalControlStateColor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = led_intf_types.LocalControlStateColor
            },
            ['OverrideStateColor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = led_intf_types.OverrideStateColor
            },
            ['Mode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.Mode
            },
            ['DefaultOSColor'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.DefaultOSColor
            },
            ['DefaultLCSColor'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = led_intf_types.DefaultLCSColor
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Led'] = {
            ['SetState'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'State'},
                    {['baseType'] = 'U8', ['param'] = 'Interval'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U8', ['param'] = 'State'},
                    {
                        ['baseType'] = 'U8',
                        ['param'] = 'OnDuration'
                    },
                    {
                        ['baseType'] = 'U8',
                        ['param'] = 'OffDuration'
                    }
                },
                ['privilege'] = {'BasicSetting'}
            }
        },
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Leds/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Led'] = {
            ['property_defaults'] = {
                ['SystemId'] = led_intf_types.SystemId.default[1],
                ['Name'] = led_intf_types.Name.default[1],
                ['OnDuration'] = 0,
                ['OffDuration'] = 0,
                ['Capability'] = led_intf_types.Capability.default[1],
                ['State'] = led_intf_types.State.default[1],
                ['Id'] = led_intf_types.Id.default[1],
                ['FruId'] = led_intf_types.FruId.default[1],
                ['ColorCapabilities'] = led_intf_types.ColorCapabilities.default[1],
                ['LocalControlStateColor'] = led_intf_types.LocalControlStateColor.default[1],
                ['OverrideStateColor'] = led_intf_types.OverrideStateColor.default[1],
                ['Mode'] = led_intf_types.Mode.default[1],
                ['DefaultOSColor'] = led_intf_types.DefaultOSColor.default[1],
                ['DefaultLCSColor'] = led_intf_types.DefaultLCSColor.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetState'] = privilege.BasicSetting}},
            ['interface_types'] = led_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Dimension = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Dimension'] = {
            ['HeightU'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dimension_intf_types.HeightU
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Dimension'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Dimension'] = {
            ['property_defaults'] = {['HeightU'] = dimension_intf_types.HeightU.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = dimension_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Chassis = {
    ['table_name'] = 't_Chassis',
    ['prop_configs'] = {
        ['IntrusionACOn'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOn
        },
        ['IntrusionACOff'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOff
        },
        ['IntrusionACOnClear'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOnClear
        },
        ['IntrusionACOffClear'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.IntrusionACOffClear
        },
        ['CoverStatus'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = chassis_class_types.CoverStatus},
        ['LastIntrusionACOn'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_class_types.LastIntrusionACOn
        },
        ['UidButtonAccessor'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonAccessor
        },
        ['UidButtonScanner'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonScanner
        },
        ['UidButtonLongAccessor'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonLongAccessor
        },
        ['UidButtonLongScanner'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = chassis_class_types.UidButtonLongScanner
        },
        ['UidButtonTestFlag'] = {
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = chassis_class_types.UidButtonTestFlag
        },
        ['UidButtonTestResult'] = {
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = chassis_class_types.UidButtonTestResult
        },
        ['UidButtonTestStatus'] = {
            ['baseType'] = 'U8',
            ['default'] = 129,
            ['validator'] = chassis_class_types.UidButtonTestStatus
        }
    },
    ['default_props'] = {
        ['IntrusionACOn'] = chassis_class_types.IntrusionACOn.default[1],
        ['IntrusionACOff'] = chassis_class_types.IntrusionACOff.default[1],
        ['IntrusionACOnClear'] = chassis_class_types.IntrusionACOnClear.default[1],
        ['IntrusionACOffClear'] = chassis_class_types.IntrusionACOffClear.default[1],
        ['CoverStatus'] = chassis_class_types.CoverStatus.default[1],
        ['LastIntrusionACOn'] = 0,
        ['UidButtonAccessor'] = chassis_class_types.UidButtonAccessor.default[1],
        ['UidButtonScanner'] = chassis_class_types.UidButtonScanner.default[1],
        ['UidButtonLongAccessor'] = chassis_class_types.UidButtonLongAccessor.default[1],
        ['UidButtonLongScanner'] = chassis_class_types.UidButtonLongScanner.default[1],
        ['UidButtonTestFlag'] = true,
        ['UidButtonTestResult'] = 255,
        ['UidButtonTestStatus'] = 129
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['primaryKey'] = true,
                ['validator'] = chassis_intf_types.Name
            },
            ['IntrusionFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.IntrusionFlag
            },
            ['UidButtonPressed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.UidButtonPressed
            },
            ['UidButtonLongPressed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.UidButtonLongPressed
            },
            ['ChassisType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.ChassisType
            },
            ['Location'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ConfigureSelf'}, ['write'] = {'BasicSetting'}},
                ['validator'] = chassis_intf_types.Location
            },
            ['TopologyConfigId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 65535,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = chassis_intf_types.TopologyConfigId
            },
            ['DeviceSpecication'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/DeviceSpecification'},
                ['readOnly'] = true,
                ['validator'] = chassis_intf_types.DeviceSpecication
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DataCollectionItem'},
                        ['param'] = 'Val'
                    }
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['param'] = 'Classification'
                    }, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['param'] = 'Identification'
                    }, {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}},
                ['rsp'] = {}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis'] = {
            ['property_defaults'] = {
                ['Name'] = chassis_intf_types.Name.default[1],
                ['IntrusionFlag'] = chassis_intf_types.IntrusionFlag.default[1],
                ['UidButtonPressed'] = chassis_intf_types.UidButtonPressed.default[1],
                ['UidButtonLongPressed'] = chassis_intf_types.UidButtonLongPressed.default[1],
                ['ChassisType'] = chassis_intf_types.ChassisType.default[1],
                ['Location'] = chassis_intf_types.Location.default[1],
                ['TopologyConfigId'] = 65535,
                ['DeviceSpecication'] = chassis_intf_types.DeviceSpecication.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['Location'] = {['read'] = privilege.ConfigureSelf, ['write'] = privilege.BasicSetting}}
            },
            ['interface_types'] = chassis_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftChassisCover = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftChassisCover/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NCSICapabilities = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NCSICapabilities'] = {
            ['PCIeNCSIEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = ncsi_capabilities_intf_types.PCIeNCSIEnabled
            },
            ['PCIeNCSISupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = ncsi_capabilities_intf_types.PCIeNCSISupported
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/NCSICapabilities'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NCSICapabilities'] = {
            ['property_defaults'] = {
                ['PCIeNCSIEnabled'] = ncsi_capabilities_intf_types.PCIeNCSIEnabled.default[1],
                ['PCIeNCSISupported'] = ncsi_capabilities_intf_types.PCIeNCSISupported.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = ncsi_capabilities_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LedDispControl = {
    ['prop_configs'] = {
        ['LedTubeSupport'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = led_disp_control_class_types.LedTubeSupport
        },
        ['LeftLedTube'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = led_disp_control_class_types.LeftLedTube
        },
        ['MidLedTube'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = led_disp_control_class_types.MidLedTube
        },
        ['RightLedTube'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = led_disp_control_class_types.RightLedTube
        }
    },
    ['default_props'] = {['LedTubeSupport'] = false, ['LeftLedTube'] = 0, ['MidLedTube'] = 0, ['RightLedTube'] = 0}
}

local I2cLed = {
    ['prop_configs'] = {
        ['CtrlValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = i2c_led_class_types.CtrlValue},
        ['LedOnValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = i2c_led_class_types.LedOnValue}
    },
    ['default_props'] = {
        ['CtrlValue'] = i2c_led_class_types.CtrlValue.default[1],
        ['LedOnValue'] = i2c_led_class_types.LedOnValue.default[1]
    }
}

local DftPysicalLed = {
    ['prop_configs'] = {
        ['DftEnable'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_pysical_led_class_types.DftEnable
        }
    },
    ['default_props'] = {['DftEnable'] = dft_pysical_led_class_types.DftEnable.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftPysicalLed/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftUidButton = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftUidButton/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftLedIntelligence = {
    ['prop_configs'] = {
        ['DftEnable'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_led_intelligence_class_types.DftEnable
        }
    },
    ['default_props'] = {['DftEnable'] = dft_led_intelligence_class_types.DftEnable.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        },
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftLedIntelligence/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftLedTube = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String',['param'] = 'Description'}
                }
            }
        },
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftLedTube/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftLedTubeIntelligence = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        },
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/CheckTest/DftLedTubeIntelligence/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local ChassisTable = {
    ['table_name'] = 't_chassis_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'ResetPer'},
            ['validator'] = chassis_table_class_types.Id
        },
        ['BmcHardResetFlag'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_table_class_types.BmcHardResetFlag
        },
        ['ProcessRestartFlag'] = {
            ['usage'] = {'TemporaryPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = chassis_table_class_types.ProcessRestartFlag
        }
    },
    ['default_props'] = {
        ['Id'] = chassis_table_class_types.Id.default[1],
        ['BmcHardResetFlag'] = 0,
        ['ProcessRestartFlag'] = 0
    }
}

local SuperPodLabel = {
    ['table_name'] = 't_SuperPodLabel',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['readOnly'] = true,
            ['default'] = 1,
            ['validator'] = super_pod_label_class_types.Id
        },
        ['SuperPodIdAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = super_pod_label_class_types.SuperPodIdAcc
        },
        ['ServerIndexAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['validator'] = super_pod_label_class_types.ServerIndexAcc
        },
        ['SuperPodSizeAcc'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['validator'] = super_pod_label_class_types.SuperPodSizeAcc
        },
        ['DefaultSuperPodId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['validator'] = super_pod_label_class_types.DefaultSuperPodId
        },
        ['DefaultServerIndex'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 65535,
            ['validator'] = super_pod_label_class_types.DefaultServerIndex
        },
        ['DefaultSuperPodSize'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 384,
            ['validator'] = super_pod_label_class_types.DefaultSuperPodSize
        },
        ['Crc16'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['validator'] = super_pod_label_class_types.Crc16
        }
    },
    ['default_props'] = {
        ['Id'] = 1,
        ['SuperPodIdAcc'] = super_pod_label_class_types.SuperPodIdAcc.default[1],
        ['ServerIndexAcc'] = super_pod_label_class_types.ServerIndexAcc.default[1],
        ['SuperPodSizeAcc'] = super_pod_label_class_types.SuperPodSizeAcc.default[1],
        ['DefaultSuperPodId'] = 4294967295,
        ['DefaultServerIndex'] = 65535,
        ['DefaultSuperPodSize'] = 384,
        ['Crc16'] = 0
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.SuperPodLabel'] = {
            ['SuperPodId'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.SuperPodId
            },
            ['ServerIndex'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 65535,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.ServerIndex
            },
            ['SuperPodSize'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 384,
                ['minimum'] = '1',
                ['maximum'] = '384',
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.SuperPodSize
            },
            ['SuperPodEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = super_pod_label_intf_types.SuperPodEnabled
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.SuperPodLabel'] = {
            ['SetSuperPodId'] = {
                ['req'] = {{['baseType'] = 'U32', ['param'] = 'SuperPodId'}},
                ['rsp'] = {{['baseType'] = 'Boolean', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetServerIndex'] = {
                ['req'] = {{['baseType'] = 'U16', ['param'] = 'ServerIndex'}},
                ['rsp'] = {{['baseType'] = 'Boolean', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetSuperPodSize'] = {
                ['req'] = {{['baseType'] = 'U16', ['param'] = 'SuperPodSize'}},
                ['rsp'] = {{['baseType'] = 'Boolean', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['RestoreDefaults'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Boolean', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetSuperPodEnabled'] = {
                ['description'] = '设置超节点模式',
                ['req'] = {{['baseType'] = 'Boolean', ['description'] = '超节点模式', ['param'] = 'SuperPodEnabled'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },            
        },
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/SuperPodLabel'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.SuperPodLabel'] = {
            ['property_defaults'] = {
                ['SuperPodId'] = 4294967295,
                ['ServerIndex'] = 65535,
                ['SuperPodSize'] = 384,
                ['SuperPodEnabled'] = false
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['SetSuperPodId'] = privilege.BasicSetting,
                    ['SetServerIndex'] = privilege.BasicSetting,
                    ['SetSuperPodSize'] = privilege.BasicSetting,
                    ['SetSuperPodEnabled'] = privilege.BasicSetting,
                    ['RestoreDefaults'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = super_pod_label_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftButtonTest = {
    ['prop_configs'] = {
        ['PressEvent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_test_class_types.PressEvent
        },
        ['ExpectedValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_test_class_types.ExpectedValue
        },
        ['ClearPressEvent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_test_class_types.ClearPressEvent
        }
    },
    ['default_props'] = {
        ['PressEvent'] = dft_button_test_class_types.PressEvent.default[1],
        ['ExpectedValue'] = dft_button_test_class_types.ExpectedValue.default[1],
        ['ClearPressEvent'] = dft_button_test_class_types.ClearPressEvent.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        },
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/OperateTest/DftButtonTest/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Enclosure = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Enclosure'] = {
            ['CabinetSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = enclosure_intf_types.CabinetSerialNumber
            },
            ['EnclosureSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = enclosure_intf_types.EnclosureSerialNumber
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Enclosure'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Enclosure'] = {
            ['property_defaults'] = {
                ['CabinetSerialNumber'] = enclosure_intf_types.CabinetSerialNumber.default[1],
                ['EnclosureSerialNumber'] = enclosure_intf_types.EnclosureSerialNumber.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = enclosure_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('LedPolicy', LedPolicy):set_bus(bus)
    class('Led', Led):set_bus(bus)
    class('Dimension', Dimension):set_bus(bus)
    class('Chassis', Chassis):set_bus(bus)
    class('DftChassisCover', DftChassisCover):set_bus(bus)
    class('NCSICapabilities', NCSICapabilities):set_bus(bus)
    class('LedDispControl', LedDispControl):set_bus(bus)
    class('I2cLed', I2cLed):set_bus(bus)
    class('DftPysicalLed', DftPysicalLed):set_bus(bus)
    class('DftUidButton', DftUidButton):set_bus(bus)
    class('DftLedIntelligence', DftLedIntelligence):set_bus(bus)
    class('DftLedTube', DftLedTube):set_bus(bus)
    class('DftLedTubeIntelligence', DftLedTubeIntelligence):set_bus(bus)
    class('ChassisTable', ChassisTable):set_bus(bus)
    class('SuperPodLabel', SuperPodLabel):set_bus(bus)
    class('DftButtonTest', DftButtonTest):set_bus(bus)
    class('Enclosure', Enclosure):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplLedLedSetState(cb)
    class('Led')['bmc.kepler.Systems.Led'].SetState = function(obj, ctx, ...)
        local req = led_intf_types.SetStateReq.new(...):validate(nil, nil, true)
        local rsp = led_intf_types.SetStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLedPropertiesGetOptions(cb)
    class('Led')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisMetricGetData(cb)
    class('Chassis')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisMetricGetItems(cb)
    class('Chassis')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplChassisMetricSynDataAcquisitionEnable(cb)
    class('Chassis')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftChassisCoverManufactureStart(cb)
    class('DftChassisCover')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftChassisCoverManufactureStop(cb)
    class('DftChassisCover')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftChassisCoverManufactureGetResult(cb)
    class('DftChassisCover')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPysicalLedManufactureStart(cb)
    class('DftPysicalLed')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPysicalLedManufactureStop(cb)
    class('DftPysicalLed')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPysicalLedManufactureGetResult(cb)
    class('DftPysicalLed')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftUidButtonManufactureStart(cb)
    class('DftUidButton')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftUidButtonManufactureStop(cb)
    class('DftUidButton')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftUidButtonManufactureGetResult(cb)
    class('DftUidButton')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedIntelligenceManufactureStart(cb)
    class('DftLedIntelligence')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedIntelligenceManufactureStop(cb)
    class('DftLedIntelligence')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedIntelligenceManufactureGetResult(cb)
    class('DftLedIntelligence')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeManufactureStart(cb)
    class('DftLedTube')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeManufactureStop(cb)
    class('DftLedTube')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeManufactureGetResult(cb)
    class('DftLedTube')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeIntelligenceManufactureStart(cb)
    class('DftLedTubeIntelligence')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeIntelligenceManufactureStop(cb)
    class('DftLedTubeIntelligence')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftLedTubeIntelligenceManufactureGetResult(cb)
    class('DftLedTubeIntelligence')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetSuperPodId(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetSuperPodId = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetSuperPodIdReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetSuperPodIdRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetServerIndex(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetServerIndex = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetServerIndexReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetServerIndexRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetSuperPodSize(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetSuperPodSize = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetSuperPodSizeReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetSuperPodSizeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelSetSuperPodEnabled(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].SetSuperPodEnabled = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.SetSuperPodEnabledReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.SetSuperPodEnabledRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSuperPodLabelSuperPodLabelRestoreDefaults(cb)
    class('SuperPodLabel')['bmc.kepler.Chassis.SuperPodLabel'].RestoreDefaults = function(obj, ctx, ...)
        local req = super_pod_label_intf_types.RestoreDefaultsReq.new(...):validate(nil, nil, true)
        local rsp = super_pod_label_intf_types.RestoreDefaultsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonTestManufactureStart(cb)
    class('DftButtonTest')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonTestManufactureStop(cb)
    class('DftButtonTest')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonTestManufactureGetResult(cb)
    class('DftButtonTest')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
