--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'chassis.ipmi.ipmi_message'

local CT = enums.ChannelType

local ChassisIpmiCmds = {}

ChassisIpmiCmds.GetDeviceCapabilities = {
    name = 'GetDeviceCapabilities',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,4E]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x4E:1/unit:8, DeviceNum]=] ..
        [=[:1/unit:8, ReadLen:1/unit:8, ReadOffset:2/unit:8, ]=] .. [=[Devices/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndFlag:1/unit:8, InfoLen:1/unit:8, Capabilities/]=] .. [=[string>>]=],
    req = msg.GetDeviceCapabilitiesReq,
    rsp = msg.GetDeviceCapabilitiesRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetDeviceCapabilities = {
    name = 'SetDeviceCapabilities',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,4F]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x4F:1/unit:8, InfoNum:1]=] ..
        [=[/unit:8, MsgLen:1/unit:8, Capabilities/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDeviceCapabilitiesReq,
    rsp = msg.SetDeviceCapabilitiesRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.ChassisIdentify = {
    name = 'ChassisIdentify',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x04,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<SrcData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.ChassisIdentifyReq,
    rsp = msg.ChassisIdentifyRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetChassisCapabilities = {
    name = 'GetChassisCapabilities',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x00,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, CapabilitiesFlags:1/uni]=] ..
        [=[t:8, FRUInfoAddr:1/unit:8, SDRAddr:1/unit:8, SELAd]=] ..
        [=[dr:1/unit:8, SystemMgmtAddr:1/unit:8, BridgeAddr:1]=] .. [=[/unit:8>>]=],
    req = msg.GetChassisCapabilitiesReq,
    rsp = msg.GetChassisCapabilitiesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetPowerCmd = {
    name = 'GetPowerCmd',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x01,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, CurrentPowerState:1/uni]=] ..
        [=[t:8, LastPowerEvent:1/unit:8, MiscChassisState:1/u]=] .. [=[nit:8, FrontPanelButton:1/unit:8>>]=],
    req = msg.GetPowerCmdReq,
    rsp = msg.GetPowerCmdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetFruLedState = {
    name = 'SetFruLedState',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x07,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<PicmgId:1/unit:8, FruId:1/unit:8, LedId:1/unit:8]=] ..
        [=[, LedFunc:1/unit:8, OnDuration:1/unit:8, Color:1/u]=] .. [=[nit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgId:1/unit:8>>]=],
    req = msg.SetFruLedStateReq,
    rsp = msg.SetFruLedStateRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetLedColorCapabilities = {
    name = 'GetLedColorCapabilities',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x06,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<PicmgId:1/unit:8, FruId:1/unit:8, LedId:1/unit:8]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgId:1/unit:8, Color]=] ..
        [=[Capabilities:1/unit:8, DefaultLCSColor:1/unit:8, D]=] .. [=[efaultOSColor:1/unit:8>>]=],
    req = msg.GetLedColorCapabilitiesReq,
    rsp = msg.GetLedColorCapabilitiesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetChassisHeight = {
    name = 'GetChassisHeight',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6C,00,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6C:1/unit:8, 0x0100:2/]=] ..
        [=[unit:8, ReadOffset:2/unit:8, ReadLen:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndFlag:1/unit:8, Data/string>>]=],
    req = msg.GetChassisHeightReq,
    rsp = msg.GetChassisHeightRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetShelfInfo = {
    name = 'GetShelfInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,30]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x30:1/unit:8, Reserved:]=] ..
        [=[1/unit:8, ShelfInfo:1/unit:8, ReadOffset:1/unit:8,]=] .. [=[ Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndFlag:1/unit:8, Data/string>>]=],
    req = msg.GetShelfInfoReq,
    rsp = msg.GetShelfInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetSuperPodLabelInfo = {
    name = 'GetSuperPodLabelInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6A,04,00,00,00,08]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6A:1/unit:8, 0x0004:2/]=] .. [=[unit:8, 0x0000:2/unit:8, 0x08:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndFlag:1/unit:8, Data/string>>]=],
    req = msg.GetSuperPodLabelInfoReq,
    rsp = msg.GetSuperPodLabelInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetSuperPodLabelInfo = {
    name = 'SetSuperPodLabelInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6B,04,00,*,00,00,09,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6B:1/unit:8, 0x0004:2/]=] ..
        [=[unit:8, Reserved:1/unit:8, 0x0000:2/unit:8, 0x09:1]=] .. [=[/unit:8, 0x00:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetSuperPodLabelInfoReq,
    rsp = msg.SetSuperPodLabelInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetSuperPodId = {
    name = 'SetSuperPodId',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6B,04,00,*,00,00,05,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6B:1/unit:8, 0x0004:2/]=] ..
        [=[unit:8, Reserved:1/unit:8, 0x0000:2/unit:8, 0x05:1]=] .. [=[/unit:8, 0x01:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetSuperPodIdReq,
    rsp = msg.SetSuperPodIdRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetServerIndex = {
    name = 'SetServerIndex',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6B,04,00,*,00,00,03,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6B:1/unit:8, 0x0004:2/]=] ..
        [=[unit:8, Reserved:1/unit:8, 0x0000:2/unit:8, 0x03:1]=] .. [=[/unit:8, 0x02:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetServerIndexReq,
    rsp = msg.SetServerIndexRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetSuperPodSize = {
    name = 'SetSuperPodSize',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6B,04,00,*,00,00,03,03]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6B:1/unit:8, 0x0004:2/]=] ..
        [=[unit:8, Reserved:1/unit:8, 0x0000:2/unit:8, 0x03:1]=] .. [=[/unit:8, 0x03:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetSuperPodSizeReq,
    rsp = msg.SetSuperPodSizeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetSuperPodEnabled = {
    name = 'SetSuperPodEnabled',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6B,05,00,*,00,00,02,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6B:1/unit:8, 0x0005:2/]=] ..
        [=[unit:8, Reserved:1/unit:8, 0x0000:2/unit:8, 0x02:1]=] .. [=[/unit:8, 0x00:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetSuperPodEnabledReq,
    rsp = msg.SetSuperPodEnabledRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.GetSuperPodEnabled = {
    name = 'GetSuperPodEnabled',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x94,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6A,05,00,00,00,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6A:1/unit:8, 0x0005:2/]=] .. [=[unit:8, 0x0000:2/unit:8, 0x01:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndFlag:1/unit:8, Data/string>>]=],
    req = msg.GetSuperPodEnabledReq,
    rsp = msg.GetSuperPodEnabledRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ChassisIpmiCmds.SetPanelButtonEnabled = {
    name = 'SetPanelButtonEnabled',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x0a,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<State:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetPanelButtonEnabledReq,
    rsp = msg.SetPanelButtonEnabledRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return ChassisIpmiCmds
