--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPanelButtonEnabled = {}

---@class ChassisIpmiCmds.SetPanelButtonEnabledReq
---@field State integer
local TSetPanelButtonEnabledReq = {}
TSetPanelButtonEnabledReq.__index = TSetPanelButtonEnabledReq
TSetPanelButtonEnabledReq.group = {}

local function TSetPanelButtonEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetPanelButtonEnabledReq)
end

function TSetPanelButtonEnabledReq.new(State)
    return TSetPanelButtonEnabledReq_from_obj({State = State})
end
---@param obj ChassisIpmiCmds.SetPanelButtonEnabledReq
function TSetPanelButtonEnabledReq:init_from_obj(obj)
    self.State = obj.State
end

function TSetPanelButtonEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPanelButtonEnabledReq.group)
end

TSetPanelButtonEnabledReq.from_obj = TSetPanelButtonEnabledReq_from_obj

TSetPanelButtonEnabledReq.proto_property = {'State'}

TSetPanelButtonEnabledReq.default = {0}

TSetPanelButtonEnabledReq.struct = {{name = 'State', is_array = false, struct = nil}}

function TSetPanelButtonEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TSetPanelButtonEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPanelButtonEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetPanelButtonEnabledReq:unpack(_)
    return self.State
end

SetPanelButtonEnabled.SetPanelButtonEnabledReq = TSetPanelButtonEnabledReq

---@class ChassisIpmiCmds.SetPanelButtonEnabledRsp
---@field CompletionCode integer
local TSetPanelButtonEnabledRsp = {}
TSetPanelButtonEnabledRsp.__index = TSetPanelButtonEnabledRsp
TSetPanelButtonEnabledRsp.group = {}

local function TSetPanelButtonEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetPanelButtonEnabledRsp)
end

function TSetPanelButtonEnabledRsp.new(CompletionCode)
    return TSetPanelButtonEnabledRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ChassisIpmiCmds.SetPanelButtonEnabledRsp
function TSetPanelButtonEnabledRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPanelButtonEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPanelButtonEnabledRsp.group)
end

TSetPanelButtonEnabledRsp.from_obj = TSetPanelButtonEnabledRsp_from_obj

TSetPanelButtonEnabledRsp.proto_property = {'CompletionCode'}

TSetPanelButtonEnabledRsp.default = {0}

TSetPanelButtonEnabledRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPanelButtonEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPanelButtonEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPanelButtonEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetPanelButtonEnabledRsp:unpack(_)
    return self.CompletionCode
end

SetPanelButtonEnabled.SetPanelButtonEnabledRsp = TSetPanelButtonEnabledRsp

return SetPanelButtonEnabled
