--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetShelfInfo = {}

---@class ChassisIpmiCmds.GetShelfInfoReq
---@field ManufactureId integer
---@field Reserved integer
---@field ShelfInfo integer
---@field ReadOffset integer
---@field Length integer
local TGetShelfInfoReq = {}
TGetShelfInfoReq.__index = TGetShelfInfoReq
TGetShelfInfoReq.group = {}

local function TGetShelfInfoReq_from_obj(obj)
    return setmetatable(obj, TGetShelfInfoReq)
end

function TGetShelfInfoReq.new(ManufactureId, Reserved, ShelfInfo, ReadOffset, Length)
    return TGetShelfInfoReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        ShelfInfo = ShelfInfo,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj ChassisIpmiCmds.GetShelfInfoReq
function TGetShelfInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.ShelfInfo = obj.ShelfInfo
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetShelfInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetShelfInfoReq.group)
end

TGetShelfInfoReq.from_obj = TGetShelfInfoReq_from_obj

TGetShelfInfoReq.proto_property = {'ManufactureId', 'Reserved', 'ShelfInfo', 'ReadOffset', 'Length'}

TGetShelfInfoReq.default = {0, 0, 0, 0, 0}

TGetShelfInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'ShelfInfo', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetShelfInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ShelfInfo', self.ShelfInfo, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetShelfInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetShelfInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetShelfInfoReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.ShelfInfo, self.ReadOffset, self.Length
end

GetShelfInfo.GetShelfInfoReq = TGetShelfInfoReq

---@class ChassisIpmiCmds.GetShelfInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndFlag integer
---@field Data string
local TGetShelfInfoRsp = {}
TGetShelfInfoRsp.__index = TGetShelfInfoRsp
TGetShelfInfoRsp.group = {}

local function TGetShelfInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetShelfInfoRsp)
end

function TGetShelfInfoRsp.new(CompletionCode, ManufactureId, EndFlag, Data)
    return TGetShelfInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndFlag = EndFlag,
        Data = Data
    })
end
---@param obj ChassisIpmiCmds.GetShelfInfoRsp
function TGetShelfInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndFlag = obj.EndFlag
    self.Data = obj.Data
end

function TGetShelfInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetShelfInfoRsp.group)
end

TGetShelfInfoRsp.from_obj = TGetShelfInfoRsp_from_obj

TGetShelfInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndFlag', 'Data'}

TGetShelfInfoRsp.default = {0, 0, 0, ''}

TGetShelfInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndFlag', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetShelfInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndFlag', self.EndFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetShelfInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetShelfInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetShelfInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndFlag, self.Data
end

GetShelfInfo.GetShelfInfoRsp = TGetShelfInfoRsp

return GetShelfInfo
