--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetChassisCapabilities = {}

---@class ChassisIpmiCmds.GetChassisCapabilitiesReq
local TGetChassisCapabilitiesReq = {}
TGetChassisCapabilitiesReq.__index = TGetChassisCapabilitiesReq
TGetChassisCapabilitiesReq.group = {}

local function TGetChassisCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TGetChassisCapabilitiesReq)
end

function TGetChassisCapabilitiesReq.new()
    return TGetChassisCapabilitiesReq_from_obj({})
end
---@param obj ChassisIpmiCmds.GetChassisCapabilitiesReq
function TGetChassisCapabilitiesReq:init_from_obj(obj)

end

function TGetChassisCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChassisCapabilitiesReq.group)
end

TGetChassisCapabilitiesReq.from_obj = TGetChassisCapabilitiesReq_from_obj

TGetChassisCapabilitiesReq.proto_property = {}

TGetChassisCapabilitiesReq.default = {}

TGetChassisCapabilitiesReq.struct = {}

function TGetChassisCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetChassisCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChassisCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TGetChassisCapabilitiesReq:unpack(_)
end

GetChassisCapabilities.GetChassisCapabilitiesReq = TGetChassisCapabilitiesReq

---@class ChassisIpmiCmds.GetChassisCapabilitiesRsp
---@field CompletionCode integer
---@field CapabilitiesFlags integer
---@field FRUInfoAddr integer
---@field SDRAddr integer
---@field SELAddr integer
---@field SystemMgmtAddr integer
---@field BridgeAddr integer
local TGetChassisCapabilitiesRsp = {}
TGetChassisCapabilitiesRsp.__index = TGetChassisCapabilitiesRsp
TGetChassisCapabilitiesRsp.group = {}

local function TGetChassisCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TGetChassisCapabilitiesRsp)
end

function TGetChassisCapabilitiesRsp.new(CompletionCode, CapabilitiesFlags, FRUInfoAddr, SDRAddr, SELAddr,
    SystemMgmtAddr, BridgeAddr)
    return TGetChassisCapabilitiesRsp_from_obj({
        CompletionCode = CompletionCode,
        CapabilitiesFlags = CapabilitiesFlags,
        FRUInfoAddr = FRUInfoAddr,
        SDRAddr = SDRAddr,
        SELAddr = SELAddr,
        SystemMgmtAddr = SystemMgmtAddr,
        BridgeAddr = BridgeAddr
    })
end
---@param obj ChassisIpmiCmds.GetChassisCapabilitiesRsp
function TGetChassisCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.CapabilitiesFlags = obj.CapabilitiesFlags
    self.FRUInfoAddr = obj.FRUInfoAddr
    self.SDRAddr = obj.SDRAddr
    self.SELAddr = obj.SELAddr
    self.SystemMgmtAddr = obj.SystemMgmtAddr
    self.BridgeAddr = obj.BridgeAddr
end

function TGetChassisCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChassisCapabilitiesRsp.group)
end

TGetChassisCapabilitiesRsp.from_obj = TGetChassisCapabilitiesRsp_from_obj

TGetChassisCapabilitiesRsp.proto_property = {
    'CompletionCode', 'CapabilitiesFlags', 'FRUInfoAddr', 'SDRAddr', 'SELAddr', 'SystemMgmtAddr', 'BridgeAddr'
}

TGetChassisCapabilitiesRsp.default = {0, 0, 0, 0, 0, 0, 0}

TGetChassisCapabilitiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'CapabilitiesFlags', is_array = false, struct = nil},
    {name = 'FRUInfoAddr', is_array = false, struct = nil}, {name = 'SDRAddr', is_array = false, struct = nil},
    {name = 'SELAddr', is_array = false, struct = nil}, {name = 'SystemMgmtAddr', is_array = false, struct = nil},
    {name = 'BridgeAddr', is_array = false, struct = nil}
}

function TGetChassisCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CapabilitiesFlags', self.CapabilitiesFlags, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FRUInfoAddr', self.FRUInfoAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SDRAddr', self.SDRAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SELAddr', self.SELAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemMgmtAddr', self.SystemMgmtAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BridgeAddr', self.BridgeAddr, 'uint8', false, errs, need_convert)

    TGetChassisCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChassisCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TGetChassisCapabilitiesRsp:unpack(_)
    return self.CompletionCode, self.CapabilitiesFlags, self.FRUInfoAddr, self.SDRAddr, self.SELAddr,
        self.SystemMgmtAddr, self.BridgeAddr
end

GetChassisCapabilities.GetChassisCapabilitiesRsp = TGetChassisCapabilitiesRsp

return GetChassisCapabilities
