--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ChassisIdentify = {}

---@class ChassisIpmiCmds.ChassisIdentifyReq
---@field SrcData string
local TChassisIdentifyReq = {}
TChassisIdentifyReq.__index = TChassisIdentifyReq
TChassisIdentifyReq.group = {}

local function TChassisIdentifyReq_from_obj(obj)
    return setmetatable(obj, TChassisIdentifyReq)
end

function TChassisIdentifyReq.new(SrcData)
    return TChassisIdentifyReq_from_obj({SrcData = SrcData})
end
---@param obj ChassisIpmiCmds.ChassisIdentifyReq
function TChassisIdentifyReq:init_from_obj(obj)
    self.SrcData = obj.SrcData
end

function TChassisIdentifyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisIdentifyReq.group)
end

TChassisIdentifyReq.from_obj = TChassisIdentifyReq_from_obj

TChassisIdentifyReq.proto_property = {'SrcData'}

TChassisIdentifyReq.default = {''}

TChassisIdentifyReq.struct = {{name = 'SrcData', is_array = false, struct = nil}}

function TChassisIdentifyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcData', self.SrcData, 'string', false, errs, need_convert)

    TChassisIdentifyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisIdentifyReq.proto_property, errs, need_convert)
    return self
end

function TChassisIdentifyReq:unpack(_)
    return self.SrcData
end

ChassisIdentify.ChassisIdentifyReq = TChassisIdentifyReq

---@class ChassisIpmiCmds.ChassisIdentifyRsp
---@field CompletionCode integer
local TChassisIdentifyRsp = {}
TChassisIdentifyRsp.__index = TChassisIdentifyRsp
TChassisIdentifyRsp.group = {}

local function TChassisIdentifyRsp_from_obj(obj)
    return setmetatable(obj, TChassisIdentifyRsp)
end

function TChassisIdentifyRsp.new(CompletionCode)
    return TChassisIdentifyRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ChassisIpmiCmds.ChassisIdentifyRsp
function TChassisIdentifyRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TChassisIdentifyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisIdentifyRsp.group)
end

TChassisIdentifyRsp.from_obj = TChassisIdentifyRsp_from_obj

TChassisIdentifyRsp.proto_property = {'CompletionCode'}

TChassisIdentifyRsp.default = {0}

TChassisIdentifyRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TChassisIdentifyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TChassisIdentifyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisIdentifyRsp.proto_property, errs, need_convert)
    return self
end

function TChassisIdentifyRsp:unpack(_)
    return self.CompletionCode
end

ChassisIdentify.ChassisIdentifyRsp = TChassisIdentifyRsp

return ChassisIdentify
