-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_service = require 'service.bios_service'
local lu = require 'luaunit'
local open_db = require 'bios.db'
local vos = require 'utils.vos'

local test_common = require 'test_common.utils'
local bus = test_common.dbus_launch('../.dbus', nil, true)

TestWriteToBmc = {}

local function construct_db()
    local ok, datas = pcall(require, 'bios.datas')
    if not ok then
        -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
        datas = nil
    end
    local db = open_db(':memory:', datas)
    return db
end

function TestWriteToBmc:test_write_firmware_data_to_bmc()
    local bios_ser = bios_service.new(bus, construct_db())
    bios_ser.get_data_opt = function ()
    end
    bios_ser.dft_mode = true
    bios_ser.upg_fw_file = false
    bios_ser.get_data_opt = function ()
        local obj  = {}
        obj.get_offset = function () 
            return 0
        end
        return obj
    end

    local ok = pcall(function ()
        bios_ser:write_firmware_data_to_bmc({}, {}, 1)
    end)
    lu.assertEquals(ok, true)

    bios_ser.dft_mode = false
    local get_file_accessible = vos.get_file_accessible
    vos.get_file_accessible = function ()
        return true
    end
    local ctx = {
        session = {
            user = {
                name = 'Admin'
            }
        }
    }
    ok = pcall(function ()
        bios_ser:write_firmware_data_to_bmc({}, {}, {}, ctx)
    end)
    lu.assertEquals(ok, true)
    vos.get_file_accessible = get_file_accessible
end

function TestWriteToBmc:test_write_prepare_firmware_data_to_bmc()
    local bios_ser = bios_service.new(bus, construct_db())
    local get_file_accessible = vos.get_file_accessible
    vos.get_file_accessible = function ()
        return true
    end
    bios_ser.dft_mode = false
    local ctx = {
        session = {
            user = {
                name = 'Admin'
            }
        }
    }
    local ok = pcall(function ()
        bios_ser:write_prepare_firmware_data_to_bmc(ctx)
    end)
    lu.assertEquals(ok, true)
    ok = pcall(function ()
        bios_ser:write_prepare_firmware_data_to_bmc()
    end)
    lu.assertEquals(ok, true)

    bios_ser.dft_mode = true
    bios_ser.upg_fw_file = {
        close = function ()
        end
    }
    ok = pcall(function ()
        bios_ser:write_prepare_firmware_data_to_bmc()
    end)
    lu.assertEquals(ok, true)
    vos.get_file_accessible = get_file_accessible
end

function TestWriteToBmc:test_write_finish_firmware_data_to_bmc()
    local bios_ser = bios_service.new(bus, construct_db())
    local get_file_accessible = vos.get_file_accessible
    vos.get_file_accessible = function ()
        return true
    end
    bios_ser.get_data_opt = function ()
    end
    bios_ser.clear_data = function ()
    end
    bios_ser.dft_mode = false
    local ctx = {
        session = {
            user = {
                name = 'Admin'
            }
        }
    }
    local ok = pcall(function ()
        bios_ser:write_finish_firmware_data_to_bmc({}, ctx)
    end)
    lu.assertEquals(ok, true)

    bios_ser.dft_mode = true
    ok = pcall(function ()
        bios_ser:write_finish_firmware_data_to_bmc({}, ctx)
    end)
    lu.assertEquals(ok, false)

    ok = pcall(function ()
        bios_ser:write_finish_firmware_data_to_bmc({})
    end)
    lu.assertEquals(ok, true)
    vos.get_file_accessible = get_file_accessible
end