-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local upgrade_service = require 'service.upgrade_service'
local lu = require 'luaunit'
local bios_factory = require 'factory.bios_factory'
local bios_enum = require 'domain.bios_firmware.defs'
local PATH<const> = '/bmc/kepler/Systems/1/'
local SYS_ID<const> = 1
local task_mgmt = require 'mc.mdb.task_mgmt'


TestUpgradeService = {}

function TestUpgradeService:test_download_one_bios()
    local mock1 = upgrade_service.check_soc_type
    upgrade_service.check_soc_type = function() return 0, 0, true end
    local mock4 = upgrade_service.download_bios
    upgrade_service.download_bios = function(...) end
    local mock2 = task_mgmt.update_task
    task_mgmt.update_task = function(...) end
    local mock3 = bios_factory.get_service
    bios_factory.get_service = function(...)
        return {
            set_spi_channel_direction = function(...) end
        }
    end
    local mock5 = upgrade_service.get_package_snapshot

    upgrade_service.get_package_snapshot = function(...)
        return {
            get_period =  function(...)
                return bios_enum.PackagePeriod.Period3
            end
        }
    end

    local ret, _ = pcall(upgrade_service.mock_download_one_bios, upgrade_service, 'sys_id', 'task_id', 0, 0)
    lu.assertEquals(ret, true)
    upgrade_service.check_soc_type = mock1
    task_mgmt.update_task = mock2
    bios_factory.get_service = mock3
    upgrade_service.download_bios = mock4
    upgrade_service.get_package_snapshot = mock5
end

function TestUpgradeService:test_set_collection()
    local mock = bios_factory.get_service
    bios_factory.get_service = function (...)
        return {
            bios_object_collection = {'test'}
        }
    end
    local ret, _ = pcall(upgrade_service.set_collection, upgrade_service, SYS_ID)
    lu.assertEquals(ret, true)

    local ret, _ = pcall(upgrade_service.set_collection, upgrade_service, nil)
    lu.assertEquals(ret, true)
    bios_factory.get_service = mock
end

function TestUpgradeService:test_pre_download_action()
    local ret, _ = pcall(upgrade_service.download_multi_bios, upgrade_service, "task_id", nil)
    lu.assertEquals(ret, false)
end
