-- Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local bios_obj = require 'pojo.bios_object_mutihost'
local boot_obj = require 'pojo.boot_object'
local boot_opt_obj = require 'pojo.boot_options_object'
local smbios_obj = require 'pojo.smbios_object'
local abstract_boot_option = require 'pojo.boot.abstract_boot_option'
local log_collector = require 'service.log_collector'

test_dump_info = {}

function test_dump_info:test_dump_bios_log()
    bios_obj.system_id = 1
    local bios_object = bios_obj.obj
    bios_obj.obj = {
        Version = '',
        BackupVersion = '',
        CurrentValueFileName= 'currentvalue.json',
        RegistryFileName = 'registry.json',
        ResultFileName = 'result.json',
        SettingFileName = 'setting.json'
    }
    bios_obj.obj.get_all_prop_names = function ()
        local props = {'Version', 'BackupVersion'}
        return props
    end
    local ok = pcall(function ()
        bios_obj:get_dump_info()
    end)
    lu.assertEquals(ok, true)

    local boot_object = boot_obj.obj
    boot_obj.obj = {
        Version = '',
        BackupVersion = ''
    }
    boot_obj.obj.get_all_prop_names = function ()
        local props = {'Version', 'BackupVersion'}
        return props
    end
    ok = pcall(function ()
        boot_obj:get_dump_info()
    end)
    lu.assertEquals(ok, true)

    local path = '/data/opt'
    ok = pcall(function ()
        bios_obj:collect_json_file(path)
    end)
    lu.assertEquals(ok, true)

    boot_obj.obj = boot_object
    bios_obj.obj = bios_object
end

function test_dump_info:test_dump_boot_log()
    local cfg_tbl = boot_opt_obj.cfg_tbl
    boot_opt_obj.cfg_tbl = {
        [1] = {}
    }
    boot_opt_obj.cfg_tbl[1].log_dump = function ()
        return ''
    end
    local ok = pcall(function ()
        boot_opt_obj:get_dump_info()
    end)
    lu.assertEquals(ok, true)

    local smbios_info = smbios_obj.smbios_info
    smbios_obj.smbios_info = {
        Version = '',
        BackupVersion = ''
    }
    smbios_obj.smbios_info.get_all_prop_names = function ()
        local props = {'Version', 'BackupVersion'}
        return props
    end
    ok = pcall(function ()
        smbios_obj:get_dump_info()
    end)
    lu.assertEquals(ok, true)

    boot_opt_obj.cfg_tbl = cfg_tbl
    smbios_obj.obj = smbios_info

    local log_prop = abstract_boot_option.log_prop
    local data = abstract_boot_option.data
    abstract_boot_option.data = {'Version', 'BackupVersion'}
    abstract_boot_option.log_prop = ''

    ok = pcall(function ()
        abstract_boot_option:log_dump()
    end)
    lu.assertEquals(ok, true)
    abstract_boot_option.data = data
    abstract_boot_option.log_prop = log_prop
end