-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_service = require 'service.bios_service'
local bios_enum = require 'bios.types.enums'
local lu = require 'luaunit'

TestBiosService = {}

function TestBiosService:test_write_data()
    local req = {}
    local data_opt = {}
    local info = {}
    data_opt.get_offset = function ()
        return 1
    end
    info.OffsetToWrite = 0
    local data = bios_service:write_data(req, info, data_opt, 1)
    lu.assertEquals(data.CompletionCode, bios_enum.BiosErrCode.BIOS_ERR_NORMALLY:value())
end

function TestBiosService:test_bios_fun()
    local tmp= {
        object_service = {},
        system_id = {},
        path = {},
        multihost_card_config = {},
        pcie_obj_array = {},
        nic_obj_array = {},
        obj_list = {},
        obj = {}
    }
    local ok, _ = pcall(function()
        bios_service:update_pcie_nic_obj_array(tmp.object_service, tmp.system_id, tmp.path, 
        tmp.tmp.multihost_card_config, tmp.pcie_obj_array, tmp.nic_obj_array, tmp.obj_list)
    end)
    lu.assertEquals(ok, false)

    local ok, _ = pcall(function()
        bios_service:get_pcie_silk_config(tmp.system_id, tmp.multihost_card_config, tmp.obj)
    end)
    lu.assertEquals(ok, true)

    local ok, _ = pcall(function()
        bios_service:get_disk_silk_config(tmp.system_id, tmp.obj)
    end)
    lu.assertEquals(ok, true)
end