-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local alarm_manager = require 'domain.alarm.alarm_manager'
local lu = require 'luaunit'
local open_local_db = require 'bios.local_db'
local utils_core = require 'utils.core'
local utils = require 'mc.utils'
local signal = require 'interface.signal'

test_alarm = {}

local function construct_local_db()
    local ok, datas = pcall(require, 'bios.datas')
    if not ok then
        -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
        datas = nil
    end
    utils.remove_file(utils_core.getcwd() .. '/bios.db')
    local local_db = open_local_db(
                        utils_core.getcwd() ..
                            '/bios.db', datas, 'poweroff')
    return local_db
end

function test_alarm:test_manager_event()
    local alarm_mgr = alarm_manager.new(construct_local_db())
    self.alarm_mgr = alarm_mgr
    local event = {
        ComponentName = 'DIMM010',
        State = 'true',
        EventKeyId = 'Memory.MemoryI2CI3CLinkAbnormal',
        MessageArgs = '[DIMM010]',
        SystemId = '1',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '1'
    }
    local ok = pcall(function ()
        alarm_mgr:manager_event(event)
    end)
    lu.assertEquals(ok, true)

    ok = pcall(function ()
        alarm_mgr:manager_event(event)
    end)
    lu.assertEquals(ok, true)

    event.State = 'false'
    ok = pcall(function ()
        alarm_mgr:manager_event(event)
    end)
    lu.assertEquals(ok, true)
end

function test_alarm:test_recover()
    local alarm_mgr = self.alarm_mgr
    local event = {
        ComponentName = 'DIMM010',
        State = 'true',
        EventKeyId = 'Memory.MemoryI2CI3CLinkAbnormal',
        MessageArgs = '[DIMM010]',
        SystemId = '1',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '1'
    }

    alarm_mgr:manager_event(event)

    local ok = pcall(function ()
        alarm_mgr.event_pool:find_all_event()
    end)
    lu.assertEquals(ok, true)

    ok = pcall(function ()
        alarm_mgr:recover(1)
    end)
    lu.assertEquals(ok, true)

    ok = pcall(function ()
        event.State = 'false'
        alarm_mgr:manager_event(event)
        alarm_mgr.event_pool:reset(1)
    end)
    lu.assertEquals(ok, true)

    ok = pcall(function ()
        alarm_mgr:recover(1)
    end)
    lu.assertEquals(ok, true)
    alarm_mgr:set_recover_status(1, false)

    alarm_mgr.event_pool.deassert_alarm_list_collection[1] = nil
    ok = pcall(function ()
        alarm_mgr:recover(1)
    end)
    lu.assertEquals(ok, true)
end

function test_alarm:test_reset()
    local alarm_mgr = self.alarm_mgr
    alarm_mgr.event_pool.deassert_alarm_list_collection[1] = nil
    local ok = pcall(function ()
        alarm_mgr.event_pool:reset(1)
    end)
    lu.assertEquals(ok, true)

    local event = {
        ComponentName = 'DIMM010',
        State = 'true',
        EventKeyId = 'Memory.MemoryI2CI3CLinkAbnormal',
        MessageArgs = '[DIMM010]',
        SystemId = '1',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '1'
    }

    alarm_mgr:manager_event(event)

    ok = pcall(function ()
        alarm_mgr.event_pool:reset(1)
    end)
    lu.assertEquals(ok, true)
end

function test_alarm:test_multihost_verify()
    local is_multihost = signal.is_multihost
    signal.is_multihost = function ()
        return true
    end

    local ok = pcall(function (...)
        signal.verify_flash()
    end)

    lu.assertEquals(ok, true)

    signal.is_multihost = is_multihost
end

function test_alarm:teardownClass()
    utils.remove_file(utils_core.getcwd() .. '/bios.db')
end