-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local test_ipmi_option = {}
require 'ipmi'
local log = require 'mc.logging'
local test_bios_common = require 'test_bios_common'

local function send_ipmi(data)
    return test_bios_common.send_ipmi(data)
end

function test_ipmi_option.test_set_ipmi_option()
    local ok = send_ipmi('0x00 0x08 0x05 0xA0 0x18 0x00 0x00 0x00')
    assert(ok == true)

    ok = send_ipmi('0x00 0x08 0x06 0x00 0x18 0x00 0x00 0x00')
    assert(ok == false)

    ok = send_ipmi('0x00 0x09 0x01 0x00 0x00')
    assert(ok == true)

    ok = send_ipmi('0x00 0x09 0x02 0x00 0x00')
    assert(ok == true)

    ok = send_ipmi('0x00 0x09 0x03 0x00 0x00')
    assert(ok == true)

    ok = send_ipmi('0x00 0x09 0x04 0x00 0x00')
    assert(ok == true)

    ok = send_ipmi('0x00 0x09 0x05 0x00 0x00')
    assert(ok == true)

    ok = send_ipmi('0x00 0x09 0x06 0x00 0x00')
    assert(ok == true)
end

function test_ipmi_option.test_set_option()
    log:info('================ test set boot option start ================')
    test_ipmi_option.test_set_ipmi_option()
    log:info('================ test set boot option end ================')
end

return test_ipmi_option
